/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;

public enum TlinkType {
    BEFORE(0),
    AFTER(1),
    OVERLAP(6),
    CONTAINS(2),
    CONTAINED_BY(3),
    BEGINS_ON(4),
    ENDS_ON(5);

    private static final int[][] TML_ABC_ARRAY;
    private final int _index;

    public static TlinkType getTlinkType(BinaryTextRelation tlink) {
        String type = tlink.getCategory();
        if (type == null) {
            return null;
        }
        return TlinkType.getTimeRelationType(type);
    }

    public static TlinkType getTimeRelationType(String name) {
        String upper = name.toUpperCase().replace("_", "-");
        if (upper.equals("BEFORE")) {
            return BEFORE;
        }
        if (upper.equals("AFTER")) {
            return AFTER;
        }
        if (upper.equals("OVERLAP") || upper.equals("UNDEFINED") || upper.isEmpty()) {
            return OVERLAP;
        }
        if (upper.equals("CONTAINS")) {
            return CONTAINS;
        }
        if (upper.equals("CONTAINED-BY")) {
            return CONTAINED_BY;
        }
        if (upper.equals("BEGINS-ON") || upper.equals("CONTINUES") || upper.equals("TERMINATES")) {
            return BEGINS_ON;
        }
        if (upper.equals("ENDS-ON") || upper.equals("INITIATES") || upper.equals("REINITIATES")) {
            return ENDS_ON;
        }
        return null;
    }

    public static TlinkType getTimeRelationType(long startA, long startB, long endA, long endB) {
        if (endA < startB) {
            return BEFORE;
        }
        if (startA > endB) {
            return AFTER;
        }
        if (endA == startB) {
            return ENDS_ON;
        }
        if (startA == endB) {
            return BEGINS_ON;
        }
        long startCompare = startA - startB;
        long endCompare = endA - endB;
        if (startCompare < 0L && endCompare > 0L) {
            return CONTAINS;
        }
        if (startCompare > 0L && endCompare < 0L) {
            return CONTAINED_BY;
        }
        if (startCompare == 0L && endCompare > 0L) {
            return BEGINS_ON;
        }
        if (startCompare < 0L && endCompare == 0L) {
            return ENDS_ON;
        }
        return OVERLAP;
    }

    public static TlinkType getCombinedTypeConservative(TlinkType typeA, TlinkType typeB) {
        if (typeA == typeB) {
            return typeA;
        }
        return OVERLAP;
    }

    public static TlinkType getCombinedTypeLiberal(TlinkType typeA, TlinkType typeB) {
        if (typeA == typeB) {
            return typeA;
        }
        if (typeA == typeB.getReciprocal()) {
            return OVERLAP;
        }
        switch (typeA) {
            case BEFORE: {
                switch (typeB) {
                    case CONTAINS: {
                        return ENDS_ON;
                    }
                    case CONTAINED_BY: {
                        return ENDS_ON;
                    }
                    case BEGINS_ON: {
                        return CONTAINS;
                    }
                    case ENDS_ON: {
                        return ENDS_ON;
                    }
                    case OVERLAP: {
                        return ENDS_ON;
                    }
                }
            }
            case AFTER: {
                switch (typeB) {
                    case CONTAINS: {
                        return BEGINS_ON;
                    }
                    case CONTAINED_BY: {
                        return BEGINS_ON;
                    }
                    case BEGINS_ON: {
                        return BEGINS_ON;
                    }
                    case ENDS_ON: {
                        return CONTAINS;
                    }
                    case OVERLAP: {
                        return BEGINS_ON;
                    }
                }
            }
            case CONTAINS: {
                switch (typeB) {
                    case BEGINS_ON: {
                        return BEGINS_ON;
                    }
                    case ENDS_ON: {
                        return ENDS_ON;
                    }
                    case OVERLAP: {
                        return CONTAINS;
                    }
                }
            }
            case CONTAINED_BY: {
                switch (typeB) {
                    case BEGINS_ON: {
                        return BEGINS_ON;
                    }
                    case ENDS_ON: {
                        return ENDS_ON;
                    }
                    case OVERLAP: {
                        return CONTAINED_BY;
                    }
                }
            }
            case OVERLAP: {
                switch (typeB) {
                    case BEGINS_ON: {
                        return BEGINS_ON;
                    }
                    case ENDS_ON: {
                        return ENDS_ON;
                    }
                }
            }
        }
        return TlinkType.getCombinedTypeLiberal(typeB, typeA);
    }

    private static TlinkType getTimeRelationType(int index) {
        switch (index) {
            case 0: {
                return BEFORE;
            }
            case 1: {
                return AFTER;
            }
            case 2: {
                return CONTAINS;
            }
            case 3: {
                return CONTAINED_BY;
            }
            case 4: {
                return BEGINS_ON;
            }
            case 5: {
                return ENDS_ON;
            }
            case 6: {
                return OVERLAP;
            }
        }
        return null;
    }

    private TlinkType(int index) {
        this._index = index;
    }

    private int getIndex() {
        return this._index;
    }

    public TlinkType getTimeRelationTypeAtoC(TlinkType tlinkTypeBtoC) {
        int relationIndex = TML_ABC_ARRAY[tlinkTypeBtoC.getIndex()][this.getIndex()];
        return TlinkType.getTimeRelationType(relationIndex);
    }

    public TlinkType getReciprocal() {
        switch (this) {
            case BEFORE: {
                return AFTER;
            }
            case AFTER: {
                return BEFORE;
            }
            case OVERLAP: {
                return OVERLAP;
            }
            case CONTAINS: {
                return CONTAINED_BY;
            }
            case CONTAINED_BY: {
                return CONTAINS;
            }
            case BEGINS_ON: {
                return ENDS_ON;
            }
            case ENDS_ON: {
                return BEGINS_ON;
            }
        }
        return null;
    }

    static {
        TML_ABC_ARRAY = new int[][]{{0, -1, -1, 0, -1, 0, -1}, {-1, 1, -1, 1, 1, -1, -1}, {0, 1, 2, -1, 1, 0, -1}, {-1, -1, 6, 3, 6, 6, 6}, {-1, 1, -1, 1, 1, 6, -1}, {0, 1, -1, 0, 6, 0, -1}, {-1, -1, 6, -1, -1, -1, -1}};
    }
}

