/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.data;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class GoldEventPrinter {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File trainFile = options.getTrainOutputDirectory();
        if (trainFile.exists()) {
            trainFile.delete();
        }
        trainFile.createNewFile();
        File devFile = options.getTestOutputDirectory();
        if (devFile.exists()) {
            devFile.delete();
        }
        devFile.createNewFile();
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<Integer> devItems = THYMEData.getPatientSets(patientSets, THYMEData.DEV_REMAINDERS);
        List<File> trainFiles = Utils.getFilesFor(trainItems, options.getInputDirectory());
        List<File> devFiles = Utils.getFilesFor(devItems, options.getInputDirectory());
        Collections.sort(trainFiles);
        CollectionReader trainCollectionReader = Utils.getCollectionReader(trainFiles);
        AnalysisEngine trainDataWriter = AnalysisEngineFactory.createEngine(EventPrinter.class, (Object[])new Object[]{"OutputFile", trainFile.getAbsoluteFile()});
        SimplePipeline.runPipeline((CollectionReader)trainCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{trainDataWriter});
        CollectionReader devCollectionReader = Utils.getCollectionReader(devFiles);
        AnalysisEngine devDataWriter = AnalysisEngineFactory.createEngine(EventPrinter.class, (Object[])new Object[]{"OutputFile", devFile.getAbsolutePath()});
        SimplePipeline.runPipeline((CollectionReader)devCollectionReader, (AnalysisEngine[])new AnalysisEngine[]{devDataWriter});
    }

    public static String tokenToString(BaseToken token) {
        String stringValue;
        String tokenType = token.getClass().getSimpleName();
        String tokenText = token.getCoveredText().toLowerCase();
        switch (tokenType) {
            case "ContractionToken": {
                stringValue = tokenText;
                break;
            }
            case "NewlineToken": {
                stringValue = "";
                break;
            }
            case "NumToken": {
                stringValue = "number_token";
                break;
            }
            case "PunctuationToken": {
                stringValue = tokenText;
                break;
            }
            case "SymbolToken": {
                stringValue = tokenText;
                break;
            }
            case "WordToken": {
                stringValue = tokenText;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid token type: " + tokenType);
            }
        }
        return stringValue;
    }

    public static class EventPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the output file")
        private String outputFile;

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            ArrayList<String> sentences = new ArrayList<String>();
            for (Sentence sentence : JCasUtil.select((JCas)systemView, Sentence.class)) {
                ArrayList<String> tokensInThisSentence = new ArrayList<String>();
                for (BaseToken baseToken : JCasUtil.selectCovered((JCas)systemView, BaseToken.class, (AnnotationFS)sentence)) {
                    List events = JCasUtil.selectCovering((JCas)goldView, EventMention.class, (int)baseToken.getBegin(), (int)baseToken.getEnd());
                    String tokenText = GoldEventPrinter.tokenToString(baseToken);
                    if (events.size() > 0) {
                        tokensInThisSentence.add("[" + tokenText + "]");
                        continue;
                    }
                    tokensInThisSentence.add(tokenText);
                }
                String sentenceAsString = String.join((CharSequence)" ", tokensInThisSentence).replaceAll("[\r\n]", " ");
                sentences.add(sentenceAsString);
            }
            try {
                Files.write(Paths.get(this.outputFile, new String[0]), sentences, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();

        @Option(longName={"output-train"})
        public File getTrainOutputDirectory();

        @Option(longName={"output-test"})
        public File getTestOutputDirectory();
    }
}

