/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class I2B2Data {
    private static final int trainDevCutoff = 600;
    static Pattern filePatt = Pattern.compile("(\\d+).xml");

    public static List<Integer> getTrainPatientSets(File xmlDirectory) {
        ArrayList<Integer> trains = new ArrayList<Integer>();
        File[] files = I2B2Data.getAllFiles(xmlDirectory, "training");
        Matcher m = null;
        for (File file : files) {
            int ptNum;
            m = filePatt.matcher(file.getName());
            if (!m.matches() || (ptNum = Integer.parseInt(m.group(1))) >= 600) continue;
            trains.add(ptNum);
        }
        return trains;
    }

    public static List<Integer> getDevPatientSets(File xmlDirectory) {
        ArrayList<Integer> devs = new ArrayList<Integer>();
        File[] files = I2B2Data.getAllFiles(xmlDirectory, "training");
        Matcher m = null;
        for (File file : files) {
            int ptNum;
            m = filePatt.matcher(file.getName());
            if (!m.matches() || (ptNum = Integer.parseInt(m.group(1))) < 600) continue;
            devs.add(ptNum);
        }
        return devs;
    }

    public static List<Integer> getTestPatientSets(File xmlDirectory) {
        ArrayList<Integer> tests = new ArrayList<Integer>();
        File[] files = I2B2Data.getAllFiles(xmlDirectory, "test");
        Matcher m = null;
        for (File file : files) {
            m = filePatt.matcher(file.getName());
            if (!m.matches()) continue;
            int ptNum = Integer.parseInt(m.group(1));
            tests.add(ptNum);
        }
        return tests;
    }

    private static File[] getAllFiles(File xmlDirectory, String sub) {
        return new File(xmlDirectory, sub).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
    }
}

