/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.data.analysis;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.cr.XMIReader;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class RelationContextViewerPipeline {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = THYMEData.getPatientSets(patientSets, THYMEData.TRAIN_REMAINDERS);
        List<File> trainFiles = RelationContextViewerPipeline.getFilesFor(trainItems, options.getInputDirectory());
        CollectionReader collectionReader = RelationContextViewerPipeline.getCollectionReader(trainFiles);
        AnalysisEngine annotationConsumer = AnalysisEngineFactory.createEngine(RelationContextPrinter.class, (Object[])new Object[]{"OutputFile", options.getOutputFile()});
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{annotationConsumer});
    }

    private static CollectionReader getCollectionReader(List<File> inputFiles) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : inputFiles) {
            if (file.isHidden()) continue;
            fileNames.add(file.getPath());
        }
        String[] paths = new String[fileNames.size()];
        fileNames.toArray(paths);
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    private static List<File> getFilesFor(List<Integer> patientSets, File inputDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : patientSets) {
            final int setNum = set;
            for (File file : inputDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains(String.format("ID%03d", setNum));
                }
            })) {
                if (file.isHidden()) continue;
                files.add(file);
            }
        }
        return files;
    }

    public static class RelationContextPrinter
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="OutputFile", mandatory=true, description="path to the file that stores relation data")
        private String outputFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            JCas systemView;
            JCas goldView;
            try {
                goldView = jCas.getView("GoldView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            try {
                systemView = jCas.getView("_InitialView");
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            BufferedWriter writer = RelationContextPrinter.getWriter(this.outputFile, true);
            try {
                for (BinaryTextRelation binaryTextRelation : JCasUtil.select((JCas)goldView, BinaryTextRelation.class)) {
                    boolean sameSentence = false;
                    Annotation arg1 = binaryTextRelation.getArg1().getArgument();
                    Annotation arg2 = binaryTextRelation.getArg2().getArgument();
                    String category = binaryTextRelation.getCategory();
                    String text = RelationContextPrinter.getTextBetweenAnnotations(systemView, arg1, arg2);
                    List sents1 = JCasUtil.selectCovering((JCas)systemView, Sentence.class, (int)arg1.getBegin(), (int)arg1.getEnd());
                    List sents2 = JCasUtil.selectCovering((JCas)systemView, Sentence.class, (int)arg2.getBegin(), (int)arg2.getEnd());
                    if (sents1.size() == 1 && sents2.size() == 1) {
                        if (sents1.get(0) == sents2.get(0)) {
                            sameSentence = true;
                        }
                    } else {
                        System.err.println("Could not find covering sent for relation: " + String.format("%s|%s|%s|%s\n", category, arg1.getCoveredText(), arg2.getCoveredText(), text));
                    }
                    String output = String.format("%s|%s|%s|%s|%s|%s|%s\n", category, arg1.getCoveredText(), arg2.getCoveredText(), text, arg1.getType().toString(), arg2.getType().toString(), sameSentence ? "same" : "different");
                    try {
                        writer.write(output);
                    }
                    catch (IOException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                        return;
                    }
                }
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }

        private static String getTextBetweenAnnotations(JCas jCas, Annotation arg1, Annotation arg2) {
            int windowSize = 15;
            String text = jCas.getDocumentText();
            int leftArgBegin = Math.min(arg1.getBegin(), arg2.getBegin());
            int rightArgEnd = Math.max(arg1.getEnd(), arg2.getEnd());
            int begin = Math.max(0, leftArgBegin - 15);
            int end = Math.min(text.length(), rightArgEnd + 15);
            return text.substring(begin, end).replaceAll("[\r\n]", " ");
        }

        private static BufferedWriter getWriter(String filePath, boolean append) {
            BufferedWriter bufferedWriter = null;
            try {
                FileWriter fileWriter = new FileWriter(filePath, append);
                bufferedWriter = new BufferedWriter(fileWriter);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return bufferedWriter;
        }
    }

    static interface Options {
        @Option(longName={"xmi-dir"})
        public File getInputDirectory();

        @Option(longName={"output-file"})
        public File getOutputFile();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();
    }
}

