/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.DistanceExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;
import org.cleartk.util.ViewUriUtil;

public class MultiTokenFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    private FeatureExtractor1 coveredText = new CoveredTextExtractor();
    private FeatureExtractor1 tokenContext = new CleartkExtractor(BaseToken.class, this.coveredText, new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()}), new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)});
    private FeatureExtractor1 mention1FeaturesExtractor = new NamingExtractor1("mention1", (FeatureExtractor1)new CombinedExtractor1(this.coveredText, this.tokenContext));
    private FeatureExtractor1 mention2FeaturesExtractor = new NamingExtractor1("mention2", (FeatureExtractor1)new CombinedExtractor1(this.coveredText, this.tokenContext));
    private CleartkExtractor tokensBetween = new CleartkExtractor(BaseToken.class, (FeatureExtractor1)new NamingExtractor1("BetweenMentions", this.coveredText), new CleartkExtractor.Context[]{new CleartkExtractor.FirstCovered(1), new CleartkExtractor.LastCovered(1), new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})});
    private String cachedDocID = null;
    private Map<EventMention, Collection<EventMention>> coveringMap;
    private DistanceExtractor nTokensBetween = new DistanceExtractor(null, BaseToken.class);

    /*
     * WARNING - void declaration
     */
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation mention1, IdentifiedAnnotation mention2) throws AnalysisEngineProcessException {
        String docId = null;
        try {
            docId = ViewUriUtil.getURI((JCas)jCas).toString();
        }
        catch (Exception e) {
            docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        }
        if (!docId.equals(this.cachedDocID)) {
            this.cachedDocID = docId;
            this.coveringMap = JCasUtil.indexCovering((JCas)jCas, EventMention.class, EventMention.class);
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        IdentifiedAnnotation arg1 = mention1;
        IdentifiedAnnotation arg2 = mention2;
        ArrayList<Object> arg1s = new ArrayList<Object>();
        if (arg1 instanceof EventMention) {
            for (EventMention event1 : this.coveringMap.get(arg1)) {
                void var11_12;
                TreebankNode treebankNode = MultiTokenFeaturesExtractor.getExpandedEvent(jCas, (IdentifiedAnnotation)event1);
                if (treebankNode == null) {
                    EventMention eventMention = event1;
                }
                arg1s.add(var11_12);
            }
            arg1 = MultiTokenFeaturesExtractor.getExpandedEvent(jCas, mention1);
            if (arg1 == null) {
                arg1 = mention1;
            }
        }
        arg1s.add(arg1);
        ArrayList<Object> arg2s = new ArrayList<Object>();
        if (arg2 instanceof EventMention) {
            for (EventMention eventMention : this.coveringMap.get(arg2)) {
                TreebankNode tempAnn = MultiTokenFeaturesExtractor.getExpandedEvent(jCas, (IdentifiedAnnotation)eventMention);
                if (tempAnn == null) {
                    tempAnn = eventMention;
                }
                arg2s.add(tempAnn);
            }
            arg2 = MultiTokenFeaturesExtractor.getExpandedEvent(jCas, mention2);
            if (arg2 == null) {
                arg2 = mention2;
            }
        }
        arg2s.add(arg2);
        for (Annotation annotation : arg1s) {
            features.addAll(this.mention1FeaturesExtractor.extract(jCas, annotation));
            for (Annotation annotation2 : arg2s) {
                features.addAll(this.tokensBetween.extractBetween(jCas, annotation, annotation2));
                features.addAll(this.nTokensBetween.extract(jCas, annotation, annotation2));
            }
        }
        for (Annotation annotation : arg2s) {
            features.addAll(this.mention2FeaturesExtractor.extract(jCas, annotation));
        }
        return features;
    }

    private static TreebankNode getExpandedEvent(JCas jCas, IdentifiedAnnotation mention) {
        List terms = JCasUtil.selectCovered(TerminalTreebankNode.class, (AnnotationFS)mention);
        if (terms == null || terms.size() == 0) {
            return null;
        }
        TreebankNode coveringNode = AnnotationTreeUtils.annotationNode((JCas)jCas, (Annotation)mention);
        if (coveringNode == null) {
            return (TreebankNode)terms.get(0);
        }
        String pos = ((TerminalTreebankNode)terms.get(0)).getNodeType();
        if (pos.startsWith("V")) {
            return coveringNode;
        }
        if (pos.startsWith("N")) {
            while (coveringNode != null && !coveringNode.getNodeType().equals("NP")) {
                coveringNode = coveringNode.getParent();
            }
        } else if (pos.startsWith("J")) {
            while (coveringNode != null && !coveringNode.getNodeType().equals("ADJP")) {
                coveringNode = coveringNode.getParent();
            }
        }
        if (coveringNode == null) {
            coveringNode = (TreebankNode)terms.get(0);
        }
        return coveringNode;
    }
}

