/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.BackwardsTimeAnnotator;
import org.apache.ctakes.temporal.ae.CRFTimeAnnotator;
import org.apache.ctakes.temporal.ae.ConstituencyBasedTimeAnnotator;
import org.apache.ctakes.temporal.ae.TemporalSequenceAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.TimeAnnotator;
import org.apache.ctakes.temporal.eval.THYMEData;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instances;
import org.cleartk.ml.SequenceDataWriter;
import org.cleartk.ml.chunking.BioChunking;

@PipeBitInfo(name="Meta Time Annotator", description="...", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN, PipeBitInfo.TypeProduct.TIMEX})
public class MetaTimeAnnotator
extends TemporalSequenceAnnotator_ImplBase {
    private BioChunking<BaseToken, TimeMention> timeChunking;
    static Class<? extends JCasAnnotator_ImplBase>[] components = new Class[]{BackwardsTimeAnnotator.class, TimeAnnotator.class, ConstituencyBasedTimeAnnotator.class, CRFTimeAnnotator.class};

    public static Class<? extends JCasAnnotator_ImplBase>[] getComponents() {
        return components;
    }

    public static AnalysisEngineDescription getDataWriterDescription(Class<? extends SequenceDataWriter<String>> dataWriterClass, File directory) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        for (Class<? extends JCasAnnotator_ImplBase> component : components) {
            builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", component.getSimpleName()}), new String[0]);
        }
        builder.add(TimeAnnotator.createEnsembleDescription(new File(directory, TimeAnnotator.class.getSimpleName()), TimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(BackwardsTimeAnnotator.createEnsembleDescription(new File(directory, BackwardsTimeAnnotator.class.getSimpleName()), BackwardsTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(ConstituencyBasedTimeAnnotator.createEnsembleDescription(new File(directory, ConstituencyBasedTimeAnnotator.class.getSimpleName()), ConstituencyBasedTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(CRFTimeAnnotator.createEnsembleDescription(new File(directory, CRFTimeAnnotator.class.getSimpleName()), CRFTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(MetaTimeAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", new File(directory, MetaTimeAnnotator.class.getSimpleName())}), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getAnnotatorDescription(File directory) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        for (Class<? extends JCasAnnotator_ImplBase> component : components) {
            builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", component.getSimpleName()}), new String[0]);
        }
        builder.add(TimeAnnotator.createEnsembleDescription(new File(directory, TimeAnnotator.class.getSimpleName()), TimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(BackwardsTimeAnnotator.createEnsembleDescription(new File(directory, BackwardsTimeAnnotator.class.getSimpleName()), BackwardsTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(ConstituencyBasedTimeAnnotator.createEnsembleDescription(new File(directory, ConstituencyBasedTimeAnnotator.class.getSimpleName()), ConstituencyBasedTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(CRFTimeAnnotator.createEnsembleDescription(new File(directory, CRFTimeAnnotator.class.getSimpleName()), CRFTimeAnnotator.class.getSimpleName()), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(MetaTimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(directory, MetaTimeAnnotator.class.getSimpleName() + File.separator + "model.jar")}), new String[0]);
        return builder.createAggregateDescription();
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.timeChunking = new BioChunking(BaseToken.class, TimeMention.class);
    }

    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment)) {
            List outcomes;
            ArrayList sequenceFeatures = new ArrayList();
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            if (this.isTraining()) {
                List times = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence);
                outcomes = this.timeChunking.createOutcomes(jCas, tokens, times);
            } else {
                outcomes = new ArrayList();
            }
            ArrayList<List> componentOutcomes = new ArrayList<List>();
            for (Class<? extends JCasAnnotator_ImplBase> component : components) {
                try {
                    JCas componentView = jCas.getView(component.getSimpleName());
                    CasCopier casCopy = new CasCopier(jCas.getCas(), componentView.getCas());
                    org.apache.uima.cas.Feature sofaFeature = jCas.getTypeSystem().getFeatureByFullName("uima.cas.AnnotationBase:sofa");
                    for (BaseToken token : tokens) {
                        BaseToken fs = (BaseToken)casCopy.copyFs((FeatureStructure)token);
                        fs.setFeatureValue(sofaFeature, (FeatureStructure)componentView.getSofa());
                        fs.addToIndexes(componentView);
                    }
                    List viewTokens = JCasUtil.selectCovered((JCas)componentView, BaseToken.class, (int)sentence.getBegin(), (int)sentence.getEnd());
                    List times = JCasUtil.selectCovered((JCas)componentView, TimeMention.class, (AnnotationFS)sentence);
                    componentOutcomes.add(this.timeChunking.createOutcomes(componentView, viewTokens, times));
                }
                catch (CASException e) {
                    e.printStackTrace();
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
            for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
                ArrayList<Feature> features = new ArrayList<Feature>();
                for (int componentNum = 0; componentNum < componentOutcomes.size(); ++componentNum) {
                    String outcome = (String)((List)componentOutcomes.get(componentNum)).get(tokenIndex);
                    if (tokenIndex > 0) {
                        features.add(new Feature(String.format("Component%d_PreviousLabel", componentNum), ((List)componentOutcomes.get(componentNum)).get(tokenIndex - 1)));
                    }
                    features.add(new Feature(String.format("Component%d_Label", componentNum), (Object)outcome));
                    if (tokenIndex >= tokens.size() - 1) continue;
                    features.add(new Feature(String.format("Component%d_NextLabel", componentNum), ((List)componentOutcomes.get(componentNum)).get(tokenIndex + 1)));
                }
                sequenceFeatures.add(features);
            }
            if (this.isTraining()) {
                this.dataWriter.write(Instances.toInstances(outcomes, sequenceFeatures));
                continue;
            }
            outcomes = this.classifier.classify(sequenceFeatures);
            this.timeChunking.createChunks(jCas, tokens, outcomes);
        }
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Segment segment : JCasUtil.select((JCas)jCas, Segment.class)) {
            if (THYMEData.SEGMENTS_TO_SKIP.contains(segment.getId())) continue;
            this.process(jCas, segment);
        }
    }
}

