/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalEntityAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.feature.ChunkingExtractor;
import org.apache.ctakes.temporal.ae.feature.PredicateArgumentExtractor;
import org.apache.ctakes.temporal.ae.feature.selection.Chi2FeatureSelection;
import org.apache.ctakes.temporal.ae.feature.selection.FeatureSelection;
import org.apache.ctakes.temporal.utils.SMOTEplus;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;

@PipeBitInfo(name="Event Annotator", description="Annotates Temporal Events.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.CHUNK, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.EVENT})
public class EventAnnotator
extends TemporalEntityAnnotator_ImplBase {
    public static final String PARAM_PROBABILITY_OF_KEEPING_A_NEGATIVE_EXAMPLE = "ProbabilityOfKeepingANegativeExample";
    @ConfigurationParameter(name="ProbabilityOfKeepingANegativeExample", mandatory=false, description="probability that a negative example should be retained for training")
    protected Float probabilityOfKeepingANegativeExample = Float.valueOf(1.0f);
    public static final String PARAM_FEATURE_SELECTION_THRESHOLD = "WhetherToDoFeatureSelection";
    @ConfigurationParameter(name="WhetherToDoFeatureSelection", mandatory=false, description="the Chi-squared threshold at which features should be removed")
    protected Float featureSelectionThreshold = Float.valueOf(-1.0f);
    public static final String PARAM_SMOTE_NUM_NEIGHBORS = "NumOfNeighborForSMOTE";
    @ConfigurationParameter(name="NumOfNeighborForSMOTE", mandatory=false, description="the number of neighbors used for minority instances for SMOTE algorithm")
    protected Float smoteNumOfNeighbors = Float.valueOf(0.0f);
    public static final String PARAM_FEATURE_SELECTION_URI = "FeatureSelectionURI";
    @ConfigurationParameter(mandatory=false, name="FeatureSelectionURI", description="provides a URI where the feature selection data will be written")
    protected URI featureSelectionURI;
    private BioChunking<BaseToken, IdentifiedAnnotation> entityChunking;
    private BioChunking<BaseToken, EventMention> eventChunking;
    private BioChunking<BaseToken, Chunk> phraseChunking;
    protected FeatureExtractor1 tokenFeatureExtractor;
    protected CleartkExtractor contextFeatureExtractor;
    private FeatureSelection<String> featureSelection;
    private static final String FEATURE_SELECTION_NAME = "SelectNeighborFeatures";

    public static AnalysisEngineDescription createDataWriterDescription(Class<?> dataWriter, File outputDirectory, float downratio, float featureSelect, float smoteNeighborNumber) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriter, "outputDirectory", outputDirectory, PARAM_PROBABILITY_OF_KEEPING_A_NEGATIVE_EXAMPLE, Float.valueOf(downratio), PARAM_FEATURE_SELECTION_THRESHOLD, Float.valueOf(featureSelect), PARAM_SMOTE_NUM_NEIGHBORS, Float.valueOf(smoteNeighborNumber)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar"), PARAM_FEATURE_SELECTION_URI, EventAnnotator.createFeatureSelectionURI(modelDirectory)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", String.format("/%s/model.jar", EventAnnotator.class.getName().toLowerCase().replace('.', '/'))});
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>(FEATURE_SELECTION_NAME, threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.entityChunking = new BioChunking(BaseToken.class, IdentifiedAnnotation.class, "typeID");
        this.phraseChunking = new BioChunking(BaseToken.class, Chunk.class, "chunkType");
        this.eventChunking = new BioChunking(BaseToken.class, EventMention.class);
        this.tokenFeatureExtractor = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.ONE_PER_CHAR), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"));
        this.contextFeatureExtractor = new CleartkExtractor(BaseToken.class, this.tokenFeatureExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)});
        if (this.featureSelectionThreshold.floatValue() < 0.0f) {
            this.featureSelection = null;
        } else {
            this.featureSelection = EventAnnotator.createFeatureSelection(this.featureSelectionThreshold.floatValue());
            if (this.featureSelectionURI != null) {
                try {
                    this.featureSelection.load(this.featureSelectionURI);
                }
                catch (IOException e) {
                    throw new ResourceInitializationException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        PredicateArgumentExtractor predicateArgumentExtractor = new PredicateArgumentExtractor(jCas);
        HashMultimap endOfEntityFeatures = HashMultimap.create();
        for (IdentifiedAnnotation entity : JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class)) {
            Object tokens;
            if (entity.getClass().equals(EventMention.class) || (tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)entity)).size() <= 0) continue;
            BaseToken lastToken = (BaseToken)tokens.get(tokens.size() - 1);
            String value = String.format("%s_%s", entity.getClass().getSimpleName(), entity.getTypeID());
            endOfEntityFeatures.put((Object)lastToken, (Object)new Feature("EndOf", (Object)value));
        }
        Random rand = new Random();
        SMOTEplus smote = new SMOTEplus((int)Math.ceil(this.smoteNumOfNeighbors.floatValue()));
        for (Sentence sentence : JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment)) {
            List<Object> entities;
            List outcomes;
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            ArrayList confidenceScores = new ArrayList();
            if (this.isTraining()) {
                ArrayList events = Lists.newArrayList();
                for (Object event : JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence)) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    events.add(event);
                }
                outcomes = this.eventChunking.createOutcomes(jCas, tokens, (List)events);
            } else {
                outcomes = new ArrayList();
            }
            int[] entityTypeIDs = new int[]{6, 2, 1, 3, 5, 0};
            if (this.isTraining()) {
                Object event;
                entities = Lists.newArrayList();
                event = JCasUtil.selectCovered((JCas)jCas, IdentifiedAnnotation.class, (AnnotationFS)sentence).iterator();
                while (event.hasNext()) {
                    Object entity = (IdentifiedAnnotation)event.next();
                    if (entity.getClass().equals(EventMention.class)) continue;
                    entities.add(entity);
                }
            } else {
                entities = JCasUtil.selectCovered((JCas)jCas, IdentifiedAnnotation.class, (AnnotationFS)sentence);
            }
            ArrayList chunkingExtractors = Lists.newArrayList();
            for (int typeID : entityTypeIDs) {
                Predicate<IdentifiedAnnotation> hasTypeID = EventAnnotator.hasEntityType(typeID);
                ArrayList subEntities = Lists.newArrayList((Iterable)Iterables.filter(entities, hasTypeID));
                chunkingExtractors.add(new ChunkingExtractor("EntityTag", this.entityChunking, jCas, tokens, subEntities));
            }
            List chunks = JCasUtil.selectCovered((JCas)jCas, Chunk.class, (AnnotationFS)sentence);
            chunkingExtractors.add(new ChunkingExtractor("PhraseTag", this.phraseChunking, jCas, tokens, chunks));
            int tokenIndex = -1;
            int nChunkLabelsBefore = 2;
            int nChunkLabelsAfter = 2;
            int nPreviousClassifications = 2;
            for (BaseToken token : tokens) {
                ++tokenIndex;
                List<Feature> features = new ArrayList<Feature>();
                for (int i = nPreviousClassifications; i > 0; --i) {
                    int index = tokenIndex - i;
                    String previousOutcome = index < 0 ? "O" : (String)outcomes.get(index);
                    features.add(new Feature("PreviousOutcome_" + i, (Object)previousOutcome));
                }
                features.addAll(this.tokenFeatureExtractor.extract(jCas, (Annotation)token));
                features.addAll(this.contextFeatureExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                features.addAll(endOfEntityFeatures.get((Object)token));
                for (ChunkingExtractor extractor : chunkingExtractors) {
                    features.addAll(extractor.extract(tokenIndex, nChunkLabelsBefore, nChunkLabelsAfter));
                }
                features.addAll(predicateArgumentExtractor.extract(token));
                if (this.featureSelection != null) {
                    features = this.featureSelection.transform(features);
                }
                if (this.isTraining()) {
                    String outcome = (String)outcomes.get(tokenIndex);
                    if (outcome.equals("O")) {
                        if (!(rand.nextDouble() <= (double)this.probabilityOfKeepingANegativeExample.floatValue())) continue;
                        this.dataWriter.write(new Instance((Object)outcome, features));
                        continue;
                    }
                    Instance minorityInst = new Instance((Object)outcome, features);
                    this.dataWriter.write(minorityInst);
                    smote.addInstance((Instance<String>)minorityInst);
                    continue;
                }
                Map.Entry maxEntry = null;
                for (Map.Entry entry : this.classifier.score(features).entrySet()) {
                    if (maxEntry != null && ((Double)entry.getValue()).compareTo((Double)maxEntry.getValue()) <= 0) continue;
                    maxEntry = entry;
                }
                outcomes.add(maxEntry.getKey());
                confidenceScores.add(maxEntry.getValue());
            }
            if (this.isTraining()) continue;
            List createdEvents = this.eventChunking.createChunks(jCas, tokens, outcomes);
            int mentionidx = 0;
            for (EventMention mention : createdEvents) {
                mention.setConfidence(((Double)confidenceScores.get(mentionidx)).floatValue());
                ++mentionidx;
                if (mention.getEvent() != null) continue;
                Event event = new Event(jCas);
                EventProperties props = new EventProperties(jCas);
                props.addToIndexes();
                event.setProperties(props);
                mention.setEvent(event);
                event.addToIndexes();
            }
        }
        if (this.isTraining() && this.smoteNumOfNeighbors.floatValue() >= 1.0f) {
            Iterable<Instance<String>> syntheticInsts = smote.populateMinorityClass();
            for (Instance<String> sytheticInst : syntheticInsts) {
                this.dataWriter.write(sytheticInst);
            }
        }
    }

    private static Predicate<IdentifiedAnnotation> hasEntityType(final int typeID) {
        return new Predicate<IdentifiedAnnotation>(){

            public boolean apply(IdentifiedAnnotation mention) {
                return mention.getTypeID() == typeID;
            }
        };
    }
}

