/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.duration.Utils;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.syntax.PunctuationToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

@PipeBitInfo(name="E-E Cross- Sentence TLinker", description="Creates Event - Event TLinks across sentences.", dependencies={PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TIMEX}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class CrossSentenceTemporalRelationAnnotator
extends JCasAnnotator_ImplBase {
    public static boolean isValidDate(String inDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(inDate.trim());
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (TimeMention timex : JCasUtil.select((JCas)jCas, TimeMention.class)) {
            String value = Utils.getTimexMLValue(timex.getCoveredText());
            boolean hasComma = false;
            EventMention precedingEvent = null;
            if (value == null || !CrossSentenceTemporalRelationAnnotator.isValidDate(value)) continue;
            List beforeTokens = JCasUtil.selectPreceding((JCas)jCas, BaseToken.class, (AnnotationFS)timex, (int)2);
            List afterTokens = JCasUtil.selectFollowing((JCas)jCas, BaseToken.class, (AnnotationFS)timex, (int)2);
            block1: for (BaseToken token : beforeTokens) {
                if (token instanceof PunctuationToken && token.getCoveredText().equals(":")) {
                    hasComma = true;
                    continue;
                }
                for (EventMention event : JCasUtil.selectCovering((JCas)jCas, EventMention.class, (AnnotationFS)token)) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    precedingEvent = event;
                    continue block1;
                }
            }
            for (BaseToken token : afterTokens) {
                if (!(token instanceof PunctuationToken) || !token.getCoveredText().equals(":")) continue;
                hasComma = true;
                break;
            }
            if (!hasComma || precedingEvent == null) continue;
            this.createRelation(jCas, (IdentifiedAnnotation)timex, (IdentifiedAnnotation)precedingEvent, "CONTAINS", 1.0);
            List newlines = JCasUtil.selectFollowing((JCas)jCas, NewlineToken.class, (AnnotationFS)timex, (int)1);
            if (newlines.isEmpty()) continue;
            NewlineToken newline = (NewlineToken)newlines.get(0);
            for (EventMention event : JCasUtil.selectBetween((JCas)jCas, EventMention.class, (AnnotationFS)timex, (AnnotationFS)newline)) {
                if (!event.getClass().equals(EventMention.class)) continue;
                this.createRelation(jCas, (IdentifiedAnnotation)precedingEvent, (IdentifiedAnnotation)event, "CONTAINS", 1.0);
            }
        }
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }
}

