/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntKeyValueIterator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.jcas.impl.JCasHashMap;

public class Int2IntHashMap {
    private static final boolean TUNE = false;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private final float loadFactor = 0.66f;
    private final int initialCapacity;
    private int[] histogram;
    private int maxProbe = 0;
    private int sizeWhichTriggersExpansion;
    private int size;
    private int[] keys;
    private int[] values;
    private boolean secondTimeShrinkable = false;

    static int nextHigherPowerOf2(int i) {
        return i < 1 ? 1 : Integer.highestOneBit(i) << (Integer.bitCount(i) == 1 ? 0 : 1);
    }

    public Int2IntHashMap() {
        this(16);
    }

    public Int2IntHashMap(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.newTableKeepSize(initialCapacity);
        this.size = 0;
    }

    private void newTableKeepSize(int capacity) {
        capacity = Math.max(16, Int2IntHashMap.nextHigherPowerOf2(capacity));
        this.keys = new int[capacity];
        this.values = new int[capacity];
        this.sizeWhichTriggersExpansion = (int)((float)capacity * 0.66f);
    }

    private void incrementSize() {
        if (this.size >= this.sizeWhichTriggersExpansion) {
            this.increaseTableCapacity();
        }
        ++this.size;
    }

    private void increaseTableCapacity() {
        int[] oldKeys = this.keys;
        int[] oldValues = this.values;
        int oldCapacity = oldKeys.length;
        int newCapacity = 2 * oldCapacity;
        this.newTableKeepSize(newCapacity);
        int vi = 0;
        for (int key : oldKeys) {
            if (key != 0) {
                this.putInner(key, oldValues[vi]);
            }
            ++vi;
        }
    }

    private void newTable(int capacity) {
        this.newTableKeepSize(capacity);
        this.size = 0;
        this.resetHistogram();
    }

    private void resetHistogram() {
    }

    public void clear() {
        if (this.size < this.sizeWhichTriggersExpansion >>> 1) {
            if (this.secondTimeShrinkable) {
                this.secondTimeShrinkable = false;
                int newCapacity = Math.max(this.initialCapacity, this.keys.length >>> 1);
                if (newCapacity < this.keys.length) {
                    this.newTable(newCapacity);
                } else {
                    Arrays.fill(this.keys, 0);
                    Arrays.fill(this.values, 0);
                }
                this.size = 0;
                this.resetHistogram();
                return;
            }
            this.secondTimeShrinkable = true;
        } else {
            this.secondTimeShrinkable = false;
        }
        this.size = 0;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0);
        this.resetHistogram();
    }

    private int find(int key) {
        int bitMask;
        if (key == 0) {
            throw new IllegalArgumentException("0 is an invalid key");
        }
        int[] localKeys = this.keys;
        int hash = JCasHashMap.hashInt(key);
        int probeAddr = hash & (bitMask = localKeys.length - 1);
        int testKey = localKeys[probeAddr];
        if (testKey == 0 || testKey == key) {
            return probeAddr;
        }
        return this.find2(localKeys, key, probeAddr);
    }

    private int find2(int[] localKeys, int key, int probeAddr) {
        int testKey;
        int bitMask = localKeys.length - 1;
        int nbrProbes = 2;
        int probeDelta = 1;
        probeAddr = bitMask & probeAddr + probeDelta++;
        while ((testKey = localKeys[probeAddr]) != 0 && testKey != key) {
            ++nbrProbes;
            probeAddr = bitMask & probeAddr + probeDelta++;
        }
        return probeAddr;
    }

    private void updateHistogram(int nbrProbes) {
        this.histogram[nbrProbes] = 1 + this.histogram[nbrProbes];
        if (this.maxProbe < nbrProbes) {
            this.maxProbe = nbrProbes;
        }
    }

    public int get(int key) {
        return key == 0 ? 0 : this.values[this.find(key)];
    }

    public boolean containsKey(int key) {
        int probeAddr = this.find(key);
        return this.keys[probeAddr] != 0;
    }

    public boolean isKeyValid(int position) {
        return position != 0 && this.keys[position] != 0;
    }

    public int put(int key, int value) {
        int i = this.find(key);
        boolean keyNotFound = this.keys[i] == 0;
        int prevValue = this.values[i];
        this.keys[i] = key;
        this.values[i] = value;
        if (keyNotFound) {
            this.incrementSize();
        }
        return prevValue;
    }

    public void putInner(int key, int value) {
        int i = this.find(key);
        assert (this.keys[i] == 0);
        this.keys[i] = key;
        this.values[i] = value;
    }

    public int size() {
        return this.size;
    }

    private int moveToNextFilled(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        int max = this.keys.length;
        while (pos < max) {
            if (this.keys[pos] != 0) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private int moveToPreviousFilled(int pos) {
        int max = this.keys.length;
        if (pos > max) {
            pos = max - 1;
        }
        while (pos >= 0) {
            if (this.keys[pos] != 0) {
                return pos;
            }
            --pos;
        }
        return pos;
    }

    public int[] getSortedKeys() {
        int size = this.size();
        if (size == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] r = new int[size];
        int i = 0;
        for (int k : this.keys) {
            if (k == 0) continue;
            r[i++] = k;
        }
        assert (i == this.size());
        Arrays.sort(r);
        return r;
    }

    public IntListIterator keyIterator() {
        return new KeyIterator();
    }

    public IntListIterator keyIterator(int aKey) {
        throw new UnsupportedOperationException();
    }

    public IntKeyValueIterator keyValueIterator() {
        return new KeyValueIterator();
    }

    public IntKeyValueIterator keyValueIterator(int aKey) {
        throw new UnsupportedOperationException();
    }

    public void showHistogram() {
    }

    private class KeyIterator
    implements IntListIterator {
        private int curPosition = 0;

        private KeyIterator() {
        }

        @Override
        public final boolean hasNext() {
            this.curPosition = Int2IntHashMap.this.moveToNextFilled(this.curPosition);
            return this.curPosition < Int2IntHashMap.this.keys.length;
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Int2IntHashMap.this.keys[this.curPosition++];
        }

        @Override
        public boolean hasPrevious() {
            this.curPosition = Int2IntHashMap.this.moveToPreviousFilled(this.curPosition);
            return this.curPosition >= 0;
        }

        @Override
        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return Int2IntHashMap.this.keys[this.curPosition--];
        }

        @Override
        public void moveToEnd() {
            this.curPosition = Int2IntHashMap.this.keys.length - 1;
        }

        @Override
        public void moveToStart() {
            this.curPosition = 0;
        }
    }

    private class KeyValueIterator
    implements IntKeyValueIterator {
        private int curPosition;

        private KeyValueIterator() {
            this.moveToFirst();
        }

        @Override
        public void dec() {
            if (this.isValid()) {
                this.curPosition = Int2IntHashMap.this.moveToPreviousFilled(this.curPosition - 1);
            }
        }

        @Override
        public int get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return Int2IntHashMap.this.keys[this.curPosition];
        }

        @Override
        public int getValue() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return Int2IntHashMap.this.values[this.curPosition];
        }

        @Override
        public void inc() {
            if (this.isValid()) {
                this.curPosition = Int2IntHashMap.this.moveToNextFilled(this.curPosition + 1);
            }
        }

        @Override
        public boolean isValid() {
            return this.curPosition >= 0 && this.curPosition < Int2IntHashMap.this.keys.length;
        }

        @Override
        public void moveToFirst() {
            this.curPosition = Int2IntHashMap.this.moveToNextFilled(0);
        }

        @Override
        public void moveToLast() {
            this.curPosition = Int2IntHashMap.this.moveToPreviousFilled(Int2IntHashMap.this.keys.length - 1);
        }

        @Override
        public Object copy() {
            KeyValueIterator it = new KeyValueIterator();
            it.curPosition = this.curPosition;
            return it;
        }

        @Override
        public void moveTo(int i) {
            throw new UnsupportedOperationException();
        }
    }
}

