/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.ae;

import java.util.HashSet;
import java.util.Set;
import org.apache.ctakes.core.util.FSUtil;
import org.apache.ctakes.sideeffect.type.PSESentence;
import org.apache.ctakes.sideeffect.util.SEUtil;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;

public class PSESentenceAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_IGNORE_SECTIONS = "SectionsToIgnore";
    private Set setionsToIgnore;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            String[] sections = (String[])this.getContext().getConfigParameterValue(PARAM_IGNORE_SECTIONS);
            this.setionsToIgnore = new HashSet();
            for (int i = 0; i < sections.length; ++i) {
                this.setionsToIgnore.add(sections[i]);
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        block0: for (Sentence sen : indexes.getAnnotationIndex(Sentence.type)) {
            int num;
            int[] previousSenSpan;
            boolean foundDrug = false;
            boolean foundPSE = false;
            if (this.setionsToIgnore.contains(sen.getSegmentId())) continue;
            FSIterator neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)sen.getBegin(), (int)(sen.getEnd() + 1));
            while (neIter.hasNext()) {
                IdentifiedAnnotation n = (IdentifiedAnnotation)((Object)neIter.next());
                if (n.getTypeID() == 2 || n.getTypeID() == 3) {
                    foundPSE = true;
                }
                if (n.getTypeID() != 1) continue;
                foundDrug = true;
            }
            if (!foundPSE) continue;
            if (foundPSE && foundDrug) {
                PSESentence ps = new PSESentence(jcas);
                ps.setBegin(sen.getBegin());
                ps.setEnd(sen.getEnd());
                ps.addToIndexes();
                continue;
            }
            if (!foundPSE || foundDrug || !SEUtil.isSpanInSameLine(jcas, (previousSenSpan = SEUtil.getSentenceSpanOfGivenSentenceNum(jcas, num = (num = sen.getSentenceNumber()) > 0 ? num - 1 : num))[0], sen.getEnd())) continue;
            neIter = FSUtil.getAnnotationsInSpanIterator((JCas)jcas, (int)IdentifiedAnnotation.type, (int)previousSenSpan[0], (int)(previousSenSpan[1] + 1));
            while (neIter.hasNext()) {
                IdentifiedAnnotation n = (IdentifiedAnnotation)((Object)neIter.next());
                if (n.getTypeID() != 1) continue;
                PSESentence ps = new PSESentence(jcas);
                ps.setBegin(previousSenSpan[0]);
                ps.setEnd(sen.getEnd());
                ps.addToIndexes();
                continue block0;
            }
        }
    }
}

