/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.util.map;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.googlecode.clearnlp.util.pair.Pair;
import com.googlecode.clearnlp.util.pair.StringDoublePair;
import java.util.HashMap;

public class Prob2DMap
extends HashMap<String, ObjectIntOpenHashMap<String>> {
    private static final String TOTAL = "_T_";
    private int i_total;

    public void add(String key, String value) {
        if (this.containsKey(key)) {
            ObjectIntOpenHashMap map = (ObjectIntOpenHashMap)this.get(key);
            map.put((Object)value, map.get((Object)value) + 1);
            map.put((Object)TOTAL, map.get((Object)TOTAL) + 1);
        } else {
            ObjectIntOpenHashMap map = new ObjectIntOpenHashMap();
            this.put(key, map);
            map.put((Object)value, 1);
            map.put((Object)TOTAL, 1);
        }
        ++this.i_total;
    }

    public int getTotal1D(String key) {
        return this.containsKey(key) ? ((ObjectIntOpenHashMap)this.get(key)).get((Object)TOTAL) : 0;
    }

    public int getTotal2D() {
        return this.i_total;
    }

    public StringDoublePair[] getProb1D(String key) {
        Pair<Double, StringDoublePair[]> p = this.getProb1DAux(key);
        return p == null ? null : (StringDoublePair[])p.o2;
    }

    public StringDoublePair getBestProb1D(String key) {
        StringDoublePair[] ps = this.getProb1D(key);
        if (ps != null) {
            StringDoublePair max = ps[0];
            int size = ps.length;
            for (int i = 1; i < size; ++i) {
                if (!(ps[i].d > max.d)) continue;
                max = ps[i];
            }
            return max;
        }
        return null;
    }

    public StringDoublePair[] getProb2D(String key) {
        StringDoublePair[] probs;
        Pair<Double, StringDoublePair[]> p = this.getProb1DAux(key);
        if (p == null) {
            return null;
        }
        double prior = (Double)p.o1;
        for (StringDoublePair prob : probs = (StringDoublePair[])p.o2) {
            prob.d *= prior;
        }
        return probs;
    }

    private Pair<Double, StringDoublePair[]> getProb1DAux(String key) {
        ObjectIntOpenHashMap map = (ObjectIntOpenHashMap)this.get(key);
        if (map == null) {
            return null;
        }
        StringDoublePair[] probs = new StringDoublePair[map.size() - 1];
        int i = 0;
        int total = map.get((Object)TOTAL);
        for (ObjectCursor cur : map.keys()) {
            String value = (String)cur.value;
            if (value.equals(TOTAL)) continue;
            probs[i++] = new StringDoublePair(value, (double)map.get((Object)value) / (double)total);
        }
        double prior = (double)total / (double)this.i_total;
        return new Pair<Double, StringDoublePair[]>(prior, probs);
    }
}

