/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.util.map;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Prob1DMap
extends ObjectIntOpenHashMap<String> {
    private int i_total;

    public void add(String key) {
        this.put(key, this.get(key) + 1);
        ++this.i_total;
    }

    public void addAll(Collection<String> col) {
        for (String s : col) {
            this.add(s);
        }
    }

    public double getProb(String key) {
        return (double)this.get(key) / (double)this.i_total;
    }

    public List<StringIntPair> toSortedList() {
        ArrayList<StringIntPair> list = new ArrayList<StringIntPair>();
        for (ObjectCursor cur : this.keys()) {
            String key = (String)cur.value;
            list.add(new StringIntPair(key, this.get(key)));
        }
        Collections.sort(list);
        return list;
    }

    public Set<String> toSet(int cutoff) {
        HashSet<String> set = new HashSet<String>();
        for (ObjectCursor cur : this.keys()) {
            String key = (String)cur.value;
            if (this.get(key) <= cutoff) continue;
            set.add(key);
        }
        return set;
    }
}

