/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.tools;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.util.list.SortedIntArrayList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TRTreePane
extends JPanel {
    private static final long serialVersionUID = 8954140478832546803L;
    private final int ARROW_W = 4;
    private final int ARROW_H = 8;
    private final int GAP_EDGE_W = 8;
    private final int GAP_EDGE_H = 20;
    private final int GAP_FORM = 25;
    private final Font FORM_FONT = new Font("Monospaced", 0, 14);
    private final FontMetrics FORM_FM = new JLabel().getFontMetrics(this.FORM_FONT);
    private final int FORM_HEIGHT = this.FORM_FM.getHeight();
    private final Font POS_FONT = new Font("Monospaced", 0, 14);
    private final FontMetrics POS_FM = new JLabel().getFontMetrics(this.POS_FONT);
    private final int POS_HEIGHT = this.POS_FM.getHeight();
    private final Font DEPREL_FONT = new Font("Monospaced", 0, 12);
    private final FontMetrics DEPREL_FM = new JLabel().getFontMetrics(this.DEPREL_FONT);
    private final int DEPREL_HEIGHT = this.DEPREL_FM.getHeight();
    private DEPTree d_tree;
    private Rectangle[] r_forms;
    private int[][] r_edges;

    public void init(DEPTree tree) {
        this.d_tree = tree;
        this.updateTree();
    }

    public void updateTree() {
        IntArrayList[] groups = this.getGeometriesGroups();
        this.r_forms = this.getGeometriesForms(groups);
        this.r_edges = this.getGeometriesEdges(groups);
        Rectangle rect = this.r_forms[this.r_forms.length - 1];
        this.setPreferredSize(new Dimension((int)rect.getMaxX() + 25, (int)rect.getMaxY() + this.FORM_HEIGHT + this.POS_HEIGHT + 8));
        this.repaint();
        this.revalidate();
    }

    private IntArrayList[] getGeometriesGroups() {
        int i;
        int size = this.d_tree.size();
        SortedIntArrayList[] lhs = new SortedIntArrayList[size];
        SortedIntArrayList[] rhs = new SortedIntArrayList[size];
        for (i = 0; i < size; ++i) {
            lhs[i] = new SortedIntArrayList(false);
            rhs[i] = new SortedIntArrayList(false);
        }
        for (i = 1; i < size; ++i) {
            DEPNode curr = this.d_tree.get(i);
            DEPNode head = curr.getHead();
            if (head == null) continue;
            if (curr.id < head.id) {
                lhs[head.id].add(curr.id);
                rhs[curr.id].add(head.id);
                continue;
            }
            lhs[curr.id].add(head.id);
            rhs[head.id].add(curr.id);
        }
        IntArrayList[] groups = new IntArrayList[size];
        for (i = 0; i < size; ++i) {
            groups[i] = new IntArrayList();
            groups[i].addAll((IntContainer)lhs[i]);
            groups[i].addAll((IntContainer)rhs[i]);
        }
        return groups;
    }

    private Rectangle[] getGeometriesForms(IntArrayList[] groups) {
        int m;
        int w;
        int i;
        int pm = 0;
        int size = this.d_tree.size();
        Rectangle[] rForms = new Rectangle[size];
        for (i = 0; i < size; ++i) {
            w = this.FORM_FM.stringWidth(this.d_tree.get((int)i).form);
            m = (groups[i].size() - 1) * 8 - w;
            m = m > 0 ? Math.round((float)m / 2.0f) : 0;
            int x = i > 0 ? (int)rForms[i - 1].getMaxX() + 25 : 25;
            rForms[i] = new Rectangle(x + m + pm, 0, w, this.FORM_HEIGHT);
            pm = m;
        }
        for (i = 1; i < size; ++i) {
            DEPNode node = this.d_tree.get(i);
            DEPNode head = node.getHead();
            if (head == null || (w = this.DEPREL_FM.stringWidth(node.getLabel()) + 20) <= (m = Math.abs(rForms[node.id].x - rForms[head.id].x))) continue;
            w -= m;
            for (int j = node.id > head.id ? node.id : head.id; j < size; ++j) {
                rForms[j].x += w;
            }
        }
        return rForms;
    }

    private int[][] getGeometriesEdges(IntArrayList[] groups) {
        int size = this.d_tree.size();
        int[] heights = this.getHeights(this.d_tree);
        int[][] rEdges = new int[size][];
        for (int i = 1; i < size; ++i) {
            DEPNode curr = this.d_tree.get(i);
            DEPNode head = curr.getHead();
            if (head == null) continue;
            int xd = this.getGeometriesEdgesAux(groups, curr.id, head.id);
            int xh = this.getGeometriesEdgesAux(groups, head.id, curr.id);
            rEdges[i] = new int[]{xd, xh, heights[i] * 20};
        }
        return rEdges;
    }

    private int[] getHeights(DEPTree tree) {
        int size = tree.size();
        int[] heights = new int[size];
        for (int i = 1; i < size; ++i) {
            this.getHeightsRec(tree, i, heights);
        }
        return heights;
    }

    private void getHeightsRec(DEPTree tree, int id, int[] heights) {
        int et;
        int st;
        DEPNode curr = tree.get(id);
        DEPNode head = curr.getHead();
        int max = 0;
        if (head == null) {
            return;
        }
        if (curr.id < head.id) {
            st = curr.id;
            et = head.id;
        } else {
            st = head.id;
            et = curr.id;
        }
        for (int i = st; i <= et; ++i) {
            DEPNode node;
            if (i == id || (node = tree.get(i).getHead()) == null || st > node.id || node.id > et) continue;
            if (heights[i] == 0) {
                this.getHeightsRec(tree, i, heights);
            }
            max = Math.max(max, heights[i]);
        }
        heights[id] = max + 1;
    }

    private int getGeometriesEdgesAux(IntArrayList[] groups, int id1, int id2) {
        return (int)(this.r_forms[id1].getCenterX() - ((double)(groups[id1].size() - 1) / 2.0 - (double)groups[id1].indexOf(id2)) * 8.0);
    }

    @Override
    public void paint(Graphics g) {
        int i;
        if (this.r_edges == null) {
            return;
        }
        super.paint(g);
        int size = this.r_edges.length;
        int maxY = 0;
        for (i = 1; i < size; ++i) {
            maxY = Math.max(maxY, this.r_edges[i][2]);
        }
        maxY += 40;
        for (i = 0; i < size; ++i) {
            DEPNode node = this.d_tree.get(i);
            g.setColor(Color.BLACK);
            g.setFont(this.FORM_FONT);
            int y = maxY + this.FORM_HEIGHT;
            g.drawString(node.form, this.r_forms[i].x, y);
            g.setColor(Color.MAGENTA);
            g.setFont(this.POS_FONT);
            int x = (int)Math.round(this.r_forms[i].getCenterX() - (double)this.POS_FM.stringWidth(node.pos) / 2.0);
            g.drawString(this.d_tree.get((int)i).pos, x, y += this.POS_HEIGHT + 2);
            g.setColor(Color.DARK_GRAY);
            g.setFont(this.DEPREL_FONT);
            String s = Integer.toString(i);
            x = (int)Math.round(this.r_forms[i].getCenterX() - (double)this.DEPREL_FM.stringWidth(s) / 2.0);
            g.drawString(s, x, y += this.DEPREL_HEIGHT + 2);
            int[] edge = this.r_edges[i];
            if (edge == null) continue;
            String deprel = node.getLabel();
            x = edge[0] < edge[1] ? edge[0] + Math.round((float)(edge[1] - edge[0]) / 2.0f) : edge[1] + Math.round((float)(edge[0] - edge[1]) / 2.0f);
            y = maxY - edge[2];
            g.setColor(Color.BLUE);
            g.setFont(this.DEPREL_FONT);
            g.drawString(deprel, x -= Math.round((float)this.DEPREL_FM.stringWidth(deprel) / 2.0f), y - this.DEPREL_HEIGHT / 2);
            g.setColor(Color.DARK_GRAY);
            this.drawArrow(g, edge[0], y, edge[0], maxY);
            g.drawLine(edge[1], y, edge[1], maxY);
            g.drawLine(edge[0], y, edge[1], y);
        }
    }

    private void drawArrow(Graphics g1, int x1, int y1, int x2, int y2) {
        Graphics2D g2 = (Graphics2D)g1.create();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g2.transform(at);
        g2.drawLine(0, 0, len, 0);
        g2.fillPolygon(new int[]{len, len - 8, len - 8, len}, new int[]{0, -4, 4, 0}, 4);
    }
}

