/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.reader.AbstractReader;
import com.googlecode.clearnlp.reader.LineReader;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.reader.RawReader;
import com.googlecode.clearnlp.reader.TOKReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class POSPredict
extends AbstractRun {
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    private String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: tagged)", required=false, metaVar="<string>")
    private String s_outputExt = "tagged";
    @Option(name="-c", usage="configuration file (required)", required=true, metaVar="<filename>")
    private String s_configXml;
    @Option(name="-m", usage="model file (required)", required=true, metaVar="<filename>")
    private String s_modelFile;

    public POSPredict() {
    }

    public POSPredict(String[] args) {
        this.initArgs(args);
        try {
            Element eConfig = UTXml.getDocumentElement(new FileInputStream(this.s_configXml));
            List<String[]> filenames = this.getFilenames(this.s_inputPath, this.s_inputExt, this.s_outputExt);
            Pair<AbstractReader<?>, String> reader = this.getReader(eConfig);
            AbstractSegmenter segmenter = ((String)reader.o2).equals("raw") ? this.getSegmenter(eConfig) : null;
            AbstractTokenizer tokenizer = ((String)reader.o2).equals("line") ? this.getTokenizer(eConfig) : null;
            Pair<POSTagger[], Double> taggers = EngineGetter.getPOSTaggers(this.s_modelFile);
            for (String[] io : filenames) {
                if (((String)reader.o2).equals("raw")) {
                    this.predict(segmenter, taggers, (RawReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("line")) {
                    this.predict(tokenizer, taggers, (LineReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("tok")) {
                    this.predict(taggers, (TOKReader)reader.o1, io[0], io[1]);
                    continue;
                }
                if (((String)reader.o2).equals("pos")) {
                    this.predict(taggers, (POSReader)reader.o1, io[0], io[1]);
                    continue;
                }
                new Exception("Invalid reader type: " + (String)reader.o2);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void predict(AbstractSegmenter segmenter, Pair<POSTagger[], Double> taggers, RawReader fin, String inputFile, String outputFile) {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        for (List<String> tokens : segmenter.getSentences(fin.getBufferedReader())) {
            Object[] nodes = EngineProcess.getPOSNodes(taggers, tokens);
            fout.println(UTArray.join(nodes, "\n") + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, LineReader fin, String inputFile, String outputFile) {
        String line;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((line = fin.next()) != null) {
            Object[] nodes = EngineProcess.getPOSNodes(tokenizer, taggers, line);
            fout.println(UTArray.join(nodes, "\n") + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(Pair<POSTagger[], Double> taggers, TOKReader fin, String inputFile, String outputFile) {
        Object tokens;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((tokens = fin.next()) != null) {
            Object[] nodes = EngineProcess.getPOSNodes(taggers, (List<String>)tokens);
            fout.println(UTArray.join(nodes, "\n") + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public void predict(Pair<POSTagger[], Double> taggers, POSReader fin, String inputFile, String outputFile) {
        Object[] nodes;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        fin.open(UTInput.createBufferedFileReader(inputFile));
        int i = 0;
        System.out.print(inputFile + ": ");
        while ((nodes = fin.next()) != null) {
            EngineProcess.predictPOS(taggers, (POSNode[])nodes);
            fout.println(UTArray.join(nodes, "\n") + "\n");
            if (++i % 1000 != 0) continue;
            System.out.print(".");
        }
        System.out.println();
        fin.close();
        fout.close();
    }

    public static void main(String[] args) {
        new POSPredict(args);
    }
}

