/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.carrotsearch.hppc.IntStack;
import com.googlecode.clearnlp.coreference.Mention;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.reader.AbstractColumnReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JointReader
extends AbstractColumnReader<DEPTree> {
    protected int i_id;
    protected int i_form;
    protected int i_lemma;
    protected int i_pos;
    protected int i_feats;
    protected int i_headId;
    protected int i_deprel;
    protected int i_xheads;
    protected int i_sheads;
    protected int i_nament;
    protected int i_coref;

    public JointReader(int iForm, int iPos) {
        this.init(-1, iForm, -1, iPos, -1, -1, -1, -1, -1, -1, -1);
    }

    public JointReader(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel) {
        this.init(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel, -1, -1, -1, -1);
    }

    public JointReader(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel, int iXHeads, int iSHeads, int iNament, int iCoref) {
        this.init(iId, iForm, iLemma, iPos, iFeats, iHeadId, iDeprel, iXHeads, iSHeads, iNament, iCoref);
    }

    public void init(int iId, int iForm, int iLemma, int iPos, int iFeats, int iHeadId, int iDeprel, int iXHeads, int iSHeads, int iNament, int iCoref) {
        this.i_id = iId;
        this.i_form = iForm;
        this.i_lemma = iLemma;
        this.i_pos = iPos;
        this.i_feats = iFeats;
        this.i_headId = iHeadId;
        this.i_deprel = iDeprel;
        this.i_xheads = iXHeads;
        this.i_sheads = iSHeads;
        this.i_nament = iNament;
        this.i_coref = iCoref;
    }

    @Override
    public DEPTree next() {
        DEPTree tree = null;
        try {
            List<String[]> lines = this.readLines();
            if (lines == null) {
                return null;
            }
            tree = this.getDEPTree(lines);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tree;
    }

    protected DEPTree getDEPTree(List<String[]> lines) {
        int i;
        int size = lines.size();
        DEPTree tree = new DEPTree();
        for (i = 0; i < size; ++i) {
            tree.add(new DEPNode());
        }
        if (this.i_sheads >= 0) {
            tree.get(0).setSHeads(new ArrayList<DEPArc>());
        }
        for (i = 0; i < size; ++i) {
            String[] tmp = lines.get(i);
            String form = tmp[this.i_form];
            int id = this.i_id < 0 ? i + 1 : Integer.parseInt(tmp[this.i_id]);
            String lemma = this.i_lemma < 0 ? null : tmp[this.i_lemma];
            String pos = this.i_pos < 0 ? null : tmp[this.i_pos];
            String feats = this.i_feats < 0 ? "_" : tmp[this.i_feats];
            String nament = this.i_nament < 0 ? null : tmp[this.i_nament];
            DEPNode node = tree.get(id);
            node.init(id, form, lemma, pos, new DEPFeat(feats));
            node.nament = nament;
            if (this.i_headId >= 0 && !tmp[this.i_headId].equals("_")) {
                node.setHead(tree.get(Integer.parseInt(tmp[this.i_headId])), tmp[this.i_deprel]);
            }
            if (this.i_sheads < 0) continue;
            node.setSHeads(this.getSHeads(tree, tmp[this.i_sheads]));
        }
        if (this.i_coref >= 0) {
            tree.setMentions(this.getMentions(lines));
        }
        return tree;
    }

    private List<DEPArc> getSHeads(DEPTree tree, String heads) {
        ArrayList<DEPArc> sHeads = new ArrayList<DEPArc>();
        if (heads.equals("_")) {
            return sHeads;
        }
        for (String head : heads.split(";")) {
            int idx = head.indexOf(":");
            int headId = Integer.parseInt(head.substring(0, idx));
            String label = head.substring(idx + 1);
            sHeads.add(new DEPArc(tree.get(headId), label));
        }
        return sHeads;
    }

    private List<Mention> getMentions(List<String[]> lines) {
        HashMap<String, IntStack> map = new HashMap<String, IntStack>();
        ArrayList<Mention> mentions = new ArrayList<Mention>();
        int size = lines.size();
        for (int i = 0; i < size; ++i) {
            String corefs = lines.get(i)[this.i_coref];
            if (corefs.equals("-")) continue;
            for (String coref : DEPFeat.P_FEATS.split(corefs)) {
                String key;
                if (coref.startsWith("(")) {
                    if (coref.endsWith(")")) {
                        key = coref.substring(1, coref.length() - 1);
                        mentions.add(new Mention(key, i + 1, i + 1));
                        continue;
                    }
                    key = coref.substring(1);
                    IntStack stack = (IntStack)map.get(key);
                    if (stack == null) {
                        stack = new IntStack();
                        map.put(key, stack);
                    }
                    stack.push(i + 1);
                    continue;
                }
                key = coref.substring(0, coref.length() - 1);
                mentions.add(new Mention(key, ((IntStack)map.get(key)).pop(), i + 1));
            }
        }
        return mentions;
    }

    @Override
    public String getType() {
        if (this.i_form < 0) {
            throw new IllegalArgumentException("The form column must be specified.");
        }
        if (this.i_pos >= 0) {
            if (this.i_lemma >= 0) {
                if (this.i_headId >= 0 && this.i_deprel >= 0) {
                    if (this.i_feats >= 0 && this.i_sheads >= 0) {
                        return "srl";
                    }
                    return "dep";
                }
                return "morph";
            }
            return "pos";
        }
        return "tok";
    }
}

