/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.feature.xml.AbstractFtrXml;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class POSFtrXml
extends AbstractFtrXml {
    public static final char SOURCE_I = 'i';
    public static final String F_FORM = "f";
    public static final String F_LEMMA = "m";
    public static final String F_POS = "p";
    public static final String F_AMBIGUITY = "a";
    public static final Pattern P_BOOLEAN = Pattern.compile("^b(\\d+)$");
    public static final Pattern P_PREFIX = Pattern.compile("^pf(\\d+)$");
    public static final Pattern P_SUFFIX = Pattern.compile("^sf(\\d+)$");
    protected static final Pattern P_FIELD = Pattern.compile("f|m|p|a");
    protected static final String CUTOFF_AMBIGUITY = "ambiguity";
    protected static final String CUTOFF_DOCUMENT_FREQUENCY = "df";
    private double[] cutoff_ambiguity;
    private int[] cutoff_df;

    public POSFtrXml(InputStream fin) {
        super(fin);
    }

    @Override
    protected void initCutoffMore(NodeList eList) {
        int size = eList.getLength();
        this.cutoff_ambiguity = new double[size];
        this.cutoff_df = new int[size];
        for (int i = 0; i < size; ++i) {
            Element eCutoff = (Element)eList.item(i);
            this.cutoff_ambiguity[i] = eCutoff.hasAttribute(CUTOFF_AMBIGUITY) ? Double.parseDouble(eCutoff.getAttribute(CUTOFF_AMBIGUITY)) : 0.0;
            this.cutoff_df[i] = eCutoff.hasAttribute(CUTOFF_DOCUMENT_FREQUENCY) ? Integer.parseInt(eCutoff.getAttribute(CUTOFF_DOCUMENT_FREQUENCY)) : 0;
        }
    }

    @Override
    protected void initMore(Document doc) {
    }

    @Override
    protected boolean validSource(char source) {
        return source == 'i';
    }

    @Override
    protected boolean validRelation(String relation) {
        return false;
    }

    @Override
    protected boolean validField(String field) {
        return P_FIELD.matcher(field).matches() || P_BOOLEAN.matcher(field).matches() || P_PREFIX.matcher(field).matches() || P_SUFFIX.matcher(field).matches();
    }

    public double getAmbiguityThreshold(int index) {
        return index < this.cutoff_ambiguity.length ? this.cutoff_ambiguity[index] : 0.0;
    }

    public int getDocumentFrequency(int index) {
        return index < this.cutoff_df.length ? this.cutoff_df[index] : 0;
    }

    public int getNumberOfConfigurations() {
        return this.cutoff_ambiguity.length;
    }
}

