/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.feature.xml.AbstractFtrXml;
import com.googlecode.clearnlp.util.UTXml;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DEPFtrXml
extends AbstractFtrXml {
    public static final char S_LAMBDA = 'l';
    public static final char S_STACK = 's';
    public static final char S_BETA = 'b';
    public static final String R_H = "h";
    public static final String R_LMD = "lmd";
    public static final String R_RMD = "rmd";
    public static final String F_FORM = "f";
    public static final String F_LEMMA = "m";
    public static final String F_POS = "p";
    public static final String F_DEPREL = "d";
    public static final String F_LNPL = "lnpl";
    public static final String F_RNPL = "rnpl";
    public static final String F_LNPB = "lnpb";
    public static final String F_RNPB = "rnpb";
    public static final Pattern P_FEAT = Pattern.compile("^ft=(.+)$");
    public static final Pattern P_BOOLEAN = Pattern.compile("^b(\\d+)$");
    protected static final Pattern P_REL = Pattern.compile("h|lmd|rmd");
    protected static final Pattern P_FIELD = Pattern.compile("f|m|p|d|lnpl|rnpl|lnpb|rnpb");
    protected final String XML_LEXICA_PUNCTUATION = "punctuation";
    private StringIntPair p_punc;

    public DEPFtrXml(InputStream fin) {
        super(fin);
    }

    public DEPFtrXml(InputStream fin, boolean skipInvisible) {
        super(fin, skipInvisible);
    }

    public String getPunctuationLabel() {
        return this.p_punc.s;
    }

    public int getPunctuationCutoff() {
        return this.p_punc.i;
    }

    @Override
    protected void initCutoffMore(NodeList eList) {
    }

    @Override
    protected void initMore(Document doc) throws Exception {
        this.initMoreLexica(doc);
    }

    private void initMoreLexica(Document doc) {
        NodeList eList = doc.getElementsByTagName("lexica");
        int size = eList.getLength();
        this.p_punc = new StringIntPair("", 0);
        for (int i = 0; i < size; ++i) {
            Element eLexica = (Element)eList.item(i);
            String type = UTXml.getTrimmedAttribute(eLexica, "type");
            String label = UTXml.getTrimmedAttribute(eLexica, "label");
            int cutoff = Integer.parseInt(UTXml.getTrimmedAttribute(eLexica, "cutoff"));
            if (!type.equals("punctuation")) continue;
            this.p_punc.set(label, cutoff);
        }
    }

    @Override
    protected boolean validSource(char source) {
        return source == 's' || source == 'l' || source == 'b';
    }

    @Override
    protected boolean validRelation(String relation) {
        return P_REL.matcher(relation).matches();
    }

    @Override
    protected boolean validField(String field) {
        return P_FIELD.matcher(field).matches() || P_FEAT.matcher(field).matches() || P_BOOLEAN.matcher(field).matches();
    }
}

