/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class TopicAssigner {
    final Pattern P_SPACE = Pattern.compile(" ");
    final Pattern P_COLON = Pattern.compile(":");
    final Pattern P_UNDER = Pattern.compile("_");

    public TopicAssigner(String depDir, String tpcDir, int threshold) throws IOException {
        for (String basename : new File(depDir).list(new FileExtFilter("dep.2"))) {
            System.out.println(basename);
            String depFile = depDir + File.separator + basename;
            String tpcFile = tpcDir + File.separator + basename;
            String outFile = depDir + File.separator + basename + ".tpc";
            this.assign(depFile, tpcFile, outFile, threshold);
        }
    }

    public void assign(String depFile, String tpcFile, String outFile, int threshold) throws IOException {
        DEPTree tree;
        List<List<String[]>> topics = this.getTopics(tpcFile, threshold);
        DEPReader reader = new DEPReader(0, 1, 2, 3, 4, 5, 6);
        reader.open(UTInput.createBufferedFileReader(depFile));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outFile);
        while ((tree = reader.next()) != null) {
            IntOpenHashSet[] sets = this.assignTopics(topics, tree);
            int size = sets.length;
            StringBuilder build = new StringBuilder();
            for (int i = 1; i < size; ++i) {
                IntOpenHashSet set = sets[i];
                if (set.isEmpty()) {
                    build.append("_");
                } else {
                    int[] indices = set.toArray();
                    Arrays.sort(indices);
                    build.append("tpc=");
                    build.append(UTArray.join(indices, ","));
                }
                build.append("\n");
            }
            fout.println(build.toString());
        }
        fout.close();
    }

    private IntOpenHashSet[] assignTopics(List<List<String[]>> topics, DEPTree tree) {
        int nodeId;
        int nSize = tree.size();
        int tSize = topics.size();
        IntOpenHashSet[] sets = new IntOpenHashSet[nSize];
        for (nodeId = 1; nodeId < nSize; ++nodeId) {
            sets[nodeId] = new IntOpenHashSet();
        }
        for (nodeId = 1; nodeId < nSize; ++nodeId) {
            for (int topicId = 0; topicId < tSize; ++topicId) {
                for (String[] topic : topics.get(topicId)) {
                    int i;
                    int iSize = topic.length;
                    boolean match = true;
                    for (i = 0; i < iSize; ++i) {
                        if (nodeId + i < nSize && tree.get((int)(nodeId + i)).form.toLowerCase().equals(topic[i])) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    for (i = 0; i < iSize; ++i) {
                        sets[nodeId + i].add(topicId);
                    }
                }
            }
        }
        return sets;
    }

    public List<List<String[]>> getTopics(String tpcFile, int threshold) throws IOException {
        String line;
        BufferedReader fin = UTInput.createBufferedFileReader(tpcFile);
        ArrayList<List<String[]>> topics = new ArrayList<List<String[]>>();
        while ((line = fin.readLine()) != null) {
            ArrayList<String[]> topic = new ArrayList<String[]>();
            for (String item : this.P_SPACE.split(line)) {
                String[] tmp = this.P_COLON.split(item);
                if (tmp.length < 2 || Integer.parseInt(tmp[1]) <= threshold) continue;
                topic.add(this.P_UNDER.split(tmp[0]));
            }
            if (topic.isEmpty()) continue;
            topics.add(topic);
        }
        fin.close();
        return topics;
    }

    public static void main(String[] args) {
        try {
            new TopicAssigner(args[0], args[1], Integer.parseInt(args[2]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

