/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.SRLEval;
import com.googlecode.clearnlp.dependency.srl.SRLabeler;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.io.FileExtFilter;
import com.googlecode.clearnlp.morphology.MPLib;
import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.map.Prob1DMap;
import com.googlecode.clearnlp.util.map.Prob2DMap;
import com.googlecode.clearnlp.util.pair.IntIntPair;
import com.googlecode.clearnlp.util.pair.StringDoublePair;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class Tmp {
    public Tmp(String[] args) throws Exception {
        int[] n;
        DEPTree tree;
        DEPReader reader = new DEPReader(0, 1, 2, 4, 5, 6, 7);
        reader.open(UTInput.createBufferedFileReader(args[0]));
        int c = 0;
        while ((tree = reader.next()) != null) {
            c += 2 * (tree.size() - 1) - 1;
        }
        for (int i : n = new int[]{1, 2, 4, 8, 16, 32, 64, 80}) {
            System.out.println(c * i);
        }
    }

    void countLR(String inputFile) {
        DEPTree tree;
        DEPReader reader = new DEPReader(0, 1, 2, 4, 6, 8, 10);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        int left = 0;
        int right = 0;
        while ((tree = reader.next()) != null) {
            tree.setDependents();
            int size = tree.size();
            for (int i = 1; i < size; ++i) {
                DEPNode node = tree.get(i);
                int prevId = -1;
                int r = 0;
                int l = 0;
                for (DEPArc arc : node.getDependents()) {
                    int depId = arc.getNode().id;
                    if (depId - prevId == 1) {
                        if (depId < node.id) {
                            ++l;
                        } else {
                            ++r;
                        }
                    }
                    prevId = depId;
                }
                if (l > 1) {
                    ++left;
                    continue;
                }
                if (r <= true) continue;
                ++right;
            }
        }
        reader.close();
        System.out.printf("Left: %d, Right: %d\n", left, right);
    }

    void measureTime() {
        int j;
        int i;
        int len = 10;
        int size = 1000000;
        long st = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            IntArrayList list = new IntArrayList();
            for (j = 0; j < len; ++j) {
                list.add(j);
            }
            list.remove(list.size() - 1);
        }
        long et = System.currentTimeMillis();
        System.out.println(et - st);
        st = System.currentTimeMillis();
        for (i = 0; i < size; ++i) {
            IntArrayDeque deque = new IntArrayDeque();
            for (j = 0; j < len; ++j) {
                deque.addLast(j);
            }
            deque.removeLast();
        }
        et = System.currentTimeMillis();
        System.out.println(et - st);
    }

    void evalSubPOS(String inputFile) throws Exception {
        String line;
        BufferedReader reader = UTInput.createBufferedFileReader(inputFile);
        Pattern delim = Pattern.compile("\t");
        int correct = 0;
        int total = 0;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] ls = delim.split(line);
            DEPFeat g = new DEPFeat(ls[6]);
            DEPFeat p = new DEPFeat(ls[7]);
            if (((String)g.get("SubPOS")).equals(p.get("SubPOS"))) {
                ++correct;
            }
            ++total;
        }
        System.out.printf("%5.2f (%d/%d)\n", 100.0 * (double)correct / (double)total, correct, total);
    }

    void projectivize(String inputFile, String outputFile) {
        DEPTree tree;
        DEPReader reader = new DEPReader(0, 1, 2, 4, 6, 8, 10);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        PrintStream fold = UTOutput.createPrintBufferedFileStream(outputFile + ".old");
        PrintStream fnew = UTOutput.createPrintBufferedFileStream(outputFile + ".new");
        int i = 0;
        while ((tree = reader.next()) != null) {
            fold.println(tree.toStringCoNLL() + "\n");
            tree.projectivize();
            fnew.println(tree.toStringCoNLL() + "\n");
            if (i % 1000 == 0) {
                System.out.print(".");
            }
            ++i;
        }
        System.out.println();
        reader.close();
        fold.close();
        fnew.close();
    }

    void wc(String inputFile) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputFile));
        int sc = 0;
        int wc = 0;
        while ((tree = reader.nextTree()) != null) {
            wc += tree.getTokens().size();
            ++sc;
        }
        System.out.println(sc + " " + wc);
    }

    void stripTrees(String[] args) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(args[0]));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(args[0] + ".strip");
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while ((tree = reader.nextTree()) != null) {
            String forms = tree.toForms();
            if (!set.contains(forms)) {
                set.add(forms);
                fout.println(tree + "\n");
            }
            ++i;
        }
        fout.close();
        System.out.println(i + " -> " + set.size());
    }

    void splitTrees(String[] args) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(args[0]));
        PrintStream[] fout = new PrintStream[]{UTOutput.createPrintBufferedFileStream(args[0] + ".trn.parse"), UTOutput.createPrintBufferedFileStream(args[0] + ".trn.raw"), UTOutput.createPrintBufferedFileStream(args[0] + ".tst.parse"), UTOutput.createPrintBufferedFileStream(args[0] + ".tst.raw")};
        int i = 0;
        while ((tree = reader.nextTree()) != null) {
            int j = i % 6 == 0 ? 2 : 0;
            fout[j].println(tree.toString() + "\n");
            fout[j + 1].println(tree.toForms());
            ++i;
        }
        for (PrintStream f : fout) {
            f.close();
        }
    }

    void printTreesForCKY(String[] args) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(args[0]));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(args[1]);
        while ((tree = reader.nextTree()) != null) {
            CTNode root = tree.getRoot();
            if (root.getChildrenSize() != 1) continue;
            int count = this.stripPunct(tree);
            if (root.getChildrenSize() <= 0 || tree.getTokens().size() - count < 4 || this.containsEmptyCategories(tree) || !this.isCKYTree(root.getChild(0))) continue;
            fout.println(tree + "\n");
        }
        reader.close();
        fout.close();
    }

    boolean containsEmptyCategories(CTTree tree) {
        for (CTNode node : tree.getTerminals()) {
            if (!node.isEmptyCategory()) continue;
            return true;
        }
        return false;
    }

    int stripPunct(CTTree tree) {
        int count = 0;
        for (CTNode node : tree.getTokens()) {
            if (!MPLib.containsOnlyPunctuation(node.form)) continue;
            node.getParent().removeChild(node);
            ++count;
        }
        return count;
    }

    boolean isCKYTree(CTNode node) {
        if (!node.isPhrase()) {
            return true;
        }
        int size = node.getChildrenSize();
        if (size != 2) {
            return false;
        }
        for (CTNode child : node.getChildren()) {
            if (this.isCKYTree(child)) continue;
            return false;
        }
        return true;
    }

    void countSRL(String[] args) {
        DEPTree tree;
        SRLReader reader = new SRLReader(0, 1, 3, 5, 6, 8, 10, 12);
        reader.open(UTInput.createBufferedFileReader(args[0]));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(args[1]);
        SRLabeler parser = new SRLabeler(fout);
        SRLEval eval = new SRLEval();
        IntIntPair p = new IntIntPair(0, 0);
        while ((tree = reader.next()) != null) {
            StringIntPair[][] gHeads = tree.getSHeads();
            parser.label(tree);
            eval.evaluate(gHeads, tree.getSHeads());
            p.i1 += parser.getNumTransitions().i1;
            p.i2 += parser.getNumTransitions().i2;
        }
        fout.close();
        eval.print();
        System.out.println(p.i1 + " " + p.i2);
    }

    void traverse(String inputFile) {
        CTTree tree;
        CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputFile));
        while ((tree = reader.nextTree()) != null) {
            this.traverseAux(tree.getRoot());
        }
    }

    void traverseAux(CTNode node) {
        if (node.isPTag("SBAR") && node.containsTags("+IN|TO") && node.containsTags("DT")) {
            System.out.println(node);
        }
        for (CTNode child : node.getChildren()) {
            this.traverseAux(child);
        }
    }

    void getTokens(String inputFile, String outputDir) {
        POSNode[] nodes;
        int i;
        POSReader reader = new POSReader(1, 3);
        String[] NAMES = new String[]{"containsOnlyPunctuation.txt", "endsWithPeriod.txt", "containsPeriod.txt", "startsWithPrime.txt", "containsPrime.txt", "containsHyphen.txt", "containsAnyPunctuation.txt"};
        int size = NAMES.length;
        Prob1DMap[] maps = new Prob1DMap[size];
        for (i = 0; i < size; ++i) {
            maps[i] = new Prob1DMap();
        }
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((nodes = reader.next()) != null) {
            EngineProcess.normalizeForms(nodes);
            for (POSNode node : nodes) {
                String lemma = MPLib.revertBracket(node.form);
                lemma = MPLib.normalizeDigits(lemma);
                if (MPLib.containsOnlyPunctuation(lemma = lemma.toLowerCase())) {
                    maps[0].add(lemma);
                    continue;
                }
                if (lemma.endsWith(".")) {
                    if (lemma.length() <= 2) continue;
                    maps[1].add(lemma);
                    continue;
                }
                if (MPLib.containsAnySpecificPunctuation(lemma, '.')) {
                    maps[2].add(lemma);
                    continue;
                }
                if (lemma.startsWith("'") || lemma.startsWith("`")) {
                    maps[3].add(lemma);
                    continue;
                }
                if (MPLib.containsAnySpecificPunctuation(lemma, '\'', '`')) {
                    maps[4].add(lemma);
                    continue;
                }
                if (MPLib.containsAnySpecificPunctuation(lemma, '-')) {
                    maps[5].add(lemma);
                    continue;
                }
                if (!MPLib.containsAnyPunctuation(lemma)) continue;
                maps[6].add(lemma);
            }
        }
        for (i = 0; i < size; ++i) {
            this.print(outputDir + File.separator + NAMES[i], maps[i]);
        }
    }

    void print(String outputFile, Prob1DMap map) {
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        for (StringIntPair p : map.toSortedList()) {
            fout.printf("%s\t%d\n", p.s, p.i);
        }
        fout.close();
    }

    void mapPropBankToDependency(String inputFile, String outputFile) {
        DEPTree tree;
        String NONE = "NONE";
        SRLReader reader = new SRLReader(0, 1, 2, 3, 4, 5, 6, 8);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        Prob2DMap map = new Prob2DMap();
        while ((tree = reader.next()) != null) {
            int size = tree.size();
            for (int i = 1; i < size; ++i) {
                DEPNode node = tree.get(i);
                DEPNode head = node.getHead();
                String deprel = node.getLabel();
                String ftags = node.getFeat("sem");
                if (ftags != null) {
                    deprel = ftags;
                }
                for (DEPArc arc : node.getSHeads()) {
                    String label = arc.getLabel();
                    if (arc.getNode() == head) {
                        map.add(label, deprel);
                        continue;
                    }
                    map.add(label, "NONE");
                }
            }
        }
        ArrayList keys = new ArrayList(map.keySet());
        DecimalFormat format = new DecimalFormat("##.##");
        Collections.sort(keys);
        for (String key : keys) {
            StringBuilder build = new StringBuilder();
            Object[] ps = map.getProb1D(key);
            Arrays.sort(ps);
            double none = 0.0;
            for (Object p : ps) {
                if (((StringDoublePair)p).s.equals("NONE")) {
                    none = ((StringDoublePair)p).d;
                    continue;
                }
                if (!(((StringDoublePair)p).d >= 0.2)) continue;
                build.append("\\d" + ((StringDoublePair)p).s.toUpperCase());
                build.append(":");
                build.append(format.format(100.0 * ((StringDoublePair)p).d));
                build.append(", ");
            }
            String tmp = build.length() == 0 ? "" : build.substring(0, build.length() - 2);
            fout.printf("%s\t%s\t%f\t%d\t%d\n", key, tmp, 100.0 * none, ((ObjectIntOpenHashMap)map.get(key)).get((Object)"NONE"), map.getTotal1D(key));
        }
        fout.close();
    }

    public List<String[]> getFilenames(String inputPath, String inputExt, String outputExt) {
        ArrayList<String[]> filenames = new ArrayList<String[]>();
        File f = new File(inputPath);
        if (f.isDirectory()) {
            for (String inputFile : f.list(new FileExtFilter(inputExt))) {
                inputFile = inputPath + File.separator + inputFile;
                String outputFile = inputFile + "." + outputExt;
                filenames.add(new String[]{inputFile, outputFile});
            }
        } else {
            filenames.add(new String[]{inputPath, inputPath + "." + outputExt});
        }
        return filenames;
    }

    public void converNonASC(String[] args) throws Exception {
        Pattern asc1 = Pattern.compile("[^\\p{ASCII}]");
        Pattern asc2 = Pattern.compile("\\p{ASCII}");
        Pattern tab = Pattern.compile("\t");
        for (String[] io : this.getFilenames(args[0], args[1], args[2])) {
            String line;
            System.out.println(io[1]);
            BufferedReader fin = UTInput.createBufferedFileReader(io[0]);
            PrintStream fout = UTOutput.createPrintBufferedFileStream(io[1]);
            while ((line = fin.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) {
                    fout.println();
                    continue;
                }
                Object[] tmp = tab.split(line);
                for (int i = 0; i < tmp.length; ++i) {
                    String str = tmp[i];
                    tmp[i] = asc2.matcher(str).find() ? asc1.matcher(str).replaceAll("") : "^ASCII";
                }
                fout.println(UTArray.join(tmp, "\t"));
            }
            fout.close();
        }
    }

    public void countSemanticDependents(String[] args) {
        DEPTree tree;
        SRLReader reader = new SRLReader(0, 1, 2, 3, 4, 5, 6, 8);
        reader.open(UTInput.createBufferedFileReader(args[0]));
        while ((tree = reader.next()) != null) {
            tree.setDependents();
            for (int i = 1; i < tree.size(); ++i) {
                DEPNode node = tree.get(i);
                DEPNode dHead = node.getHead();
                for (DEPArc sArc : node.getSHeads()) {
                    DEPNode sHead = sArc.getNode();
                    if (sHead == dHead || sHead == dHead.getHead() || !node.isDescendentOf(sHead)) continue;
                    System.out.println(node.id + " " + sArc.getNode().id + " " + tree.toStringSRL());
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            new Tmp(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

