/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.experiment;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.SRLEval;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import com.googlecode.clearnlp.predicate.PredIdentifier;
import com.googlecode.clearnlp.reader.DEPReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class PredDevelop
extends AbstractRun {
    protected final int MODEL_SIZE = 2;
    protected final String ENTRY_FEATURE = "FEATURE";
    protected final String ENTRY_MODEL = "MODEL";
    protected final String ENTRY_THRESHOLD = "THRESHOLD";
    @Option(name="-i", usage="the training file (input; required)", required=true, metaVar="<filename>")
    private String s_trainFile;
    @Option(name="-d", usage="the directory containing development file (input; required)", required=true, metaVar="<filename>")
    private String s_devFile;
    @Option(name="-c", usage="the configuration file (input; required)", required=true, metaVar="<filename>")
    private String s_configXml;
    @Option(name="-f", usage="the feature file (input; required)", required=true, metaVar="<filename>")
    private String s_featureXml;

    public PredDevelop() {
    }

    public PredDevelop(String[] args) {
        this.initArgs(args);
        try {
            this.run(this.s_configXml, this.s_featureXml, this.s_trainFile, this.s_devFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run(String configXml, String featureXml, String trnFile, String devFile) throws Exception {
        Element eConfig = UTXml.getDocumentElement(new FileInputStream(configXml));
        DEPReader reader = (DEPReader)this.getReader((Element)eConfig).o1;
        SRLFtrXml xml = new SRLFtrXml(new FileInputStream(featureXml));
        this.develop(eConfig, reader, xml, trnFile, devFile);
    }

    protected void develop(Element eConfig, DEPReader reader, SRLFtrXml xml, String trnFile, String devFile) throws Exception {
        DEPTree tree;
        StringTrainSpace space = new StringTrainSpace(false, xml.getLabelCutoff(0), xml.getFeatureCutoff(0));
        PredIdentifier pred = new PredIdentifier(xml, space);
        int[] scores = new int[]{0, 0, 0};
        reader.open(UTInput.createBufferedFileReader(trnFile));
        System.out.print("Training: ");
        int i = 0;
        while ((tree = reader.next()) != null) {
            pred.identify(tree);
            if (i % 1000 == 0) {
                System.out.print(".");
            }
            ++i;
        }
        System.out.println(i);
        reader.close();
        StringModel model = (StringModel)this.getModel(UTXml.getFirstElementByTagName(eConfig, "train"), space, 0);
        pred = new PredIdentifier(xml, model);
        reader.open(UTInput.createBufferedFileReader(devFile));
        System.out.print("Predicting: ");
        i = 0;
        while ((tree = reader.next()) != null) {
            String[] gRolesets = this.getGoldRolesets(tree);
            pred.identify(tree);
            this.countScores(tree, gRolesets, scores);
            if (i % 1000 == 0) {
                System.out.print(".");
            }
            ++i;
        }
        System.out.println();
        reader.close();
        double precision = 100.0 * (double)scores[0] / (double)scores[1];
        double recall = 100.0 * (double)scores[0] / (double)scores[2];
        double f1 = SRLEval.getF1(precision, recall);
        System.out.printf("P: %5.2f (%d/%d)\n", precision, scores[0], scores[1]);
        System.out.printf("R: %5.2f (%d/%d)\n", recall, scores[0], scores[2]);
        System.out.printf("F: %5.2f\n", f1);
    }

    String[] getGoldRolesets(DEPTree tree) {
        int size = tree.size();
        String[] rolesets = new String[size];
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            rolesets[i] = node.getFeat("pb");
        }
        return rolesets;
    }

    void countScores(DEPTree tree, String[] gRolesets, int[] scores) {
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            String gRoleset = gRolesets[i];
            String sRoleset = node.getFeat("pb");
            if (sRoleset != null) {
                scores[1] = scores[1] + 1;
            }
            if (gRoleset == null) continue;
            scores[2] = scores[2] + 1;
            if (sRoleset == null) continue;
            scores[0] = scores[0] + 1;
        }
    }

    public static void main(String[] args) {
        new PredDevelop(args);
    }
}

