/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.engine;

import com.googlecode.clearnlp.component.srl.CRolesetClassifier;
import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.dependency.srl.AbstractSRLabeler;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.morphology.MPLib;
import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.propbank.verbnet.PVMap;
import com.googlecode.clearnlp.propbank.verbnet.PVRole;
import com.googlecode.clearnlp.propbank.verbnet.PVRoles;
import com.googlecode.clearnlp.propbank.verbnet.PVRoleset;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTCollection;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EngineProcess {
    public static List<List<String>> getSentences(AbstractSegmenter segmenter, BufferedReader fin) {
        return segmenter.getSentences(fin);
    }

    public static POSNode[] getPOSNodes(Pair<POSTagger[], Double> taggers, List<String> tokens) {
        POSNode[] nodes = EngineProcess.toPOSNodes(tokens);
        EngineProcess.predictPOS(taggers, nodes);
        return nodes;
    }

    public static POSNode[] getPOSNodesWithLemmas(Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, List<String> tokens) {
        POSNode[] nodes = EngineProcess.getPOSNodes(taggers, tokens);
        analyzer.lemmatize(nodes);
        return nodes;
    }

    public static DEPTree getDEPTree(Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, List<String> tokens) {
        POSNode[] nodes = EngineProcess.getPOSNodesWithLemmas(taggers, analyzer, tokens);
        DEPTree tree = EngineProcess.toDEPTree(nodes);
        parser.parse(tree);
        return tree;
    }

    public static DEPTree getDEPTree(Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, List<String> tokens) {
        DEPTree tree = EngineProcess.getDEPTree(taggers, analyzer, parser, tokens);
        EngineProcess.predictSRL(identifier, labeler, tree);
        return tree;
    }

    public static List<String> getTokens(AbstractTokenizer tokenizer, String sentence) {
        return tokenizer.getTokens(sentence);
    }

    public static POSNode[] getPOSNodes(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, String sentence) {
        List<String> tokens = EngineProcess.getTokens(tokenizer, sentence);
        return EngineProcess.getPOSNodes(taggers, tokens);
    }

    public static POSNode[] getPOSNodesWithLemmas(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, String sentence) {
        List<String> tokens = EngineProcess.getTokens(tokenizer, sentence);
        return EngineProcess.getPOSNodesWithLemmas(taggers, analyzer, tokens);
    }

    public static DEPTree getDEPTree(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, String sentence) {
        List<String> tokens = EngineProcess.getTokens(tokenizer, sentence);
        return EngineProcess.getDEPTree(taggers, analyzer, parser, tokens);
    }

    public static DEPTree getDEPTree(AbstractTokenizer tokenizer, Pair<POSTagger[], Double> taggers, AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, String sentence) {
        List<String> tokens = EngineProcess.getTokens(tokenizer, sentence);
        return EngineProcess.getDEPTree(taggers, analyzer, parser, identifier, labeler, tokens);
    }

    public static DEPTree getDEPTree(AbstractMPAnalyzer analyzer, AbstractDEPParser parser, POSNode[] nodes) {
        DEPTree tree = EngineProcess.toDEPTree(nodes);
        analyzer.lemmatize(tree);
        parser.parse(tree);
        return tree;
    }

    public static DEPTree getDEPTree(AbstractMPAnalyzer analyzer, AbstractDEPParser parser, AbstractPredIdentifier identifier, AbstractSRLabeler labeler, POSNode[] nodes) {
        DEPTree tree = EngineProcess.getDEPTree(analyzer, parser, nodes);
        EngineProcess.predictSRL(identifier, labeler, tree);
        return tree;
    }

    public static void predictPOS(Pair<POSTagger[], Double> taggers, POSNode[] nodes) {
        EngineProcess.normalizeForms(nodes);
        if (((POSTagger[])taggers.o1).length == 1 || (Double)taggers.o2 < ((POSTagger[])taggers.o1)[0].getCosineSimilarity(nodes)) {
            ((POSTagger[])taggers.o1)[0].tag(nodes);
        } else {
            ((POSTagger[])taggers.o1)[1].tag(nodes);
        }
    }

    public static void normalizeForms(POSNode[] nodes) {
        if (!nodes[0].isSimplifiedForm("_N_")) {
            return;
        }
        for (POSNode node : nodes) {
            node.simplifiedForm = MPLib.normalizeBasic(node.form);
            node.lemma = node.simplifiedForm.toLowerCase();
        }
    }

    public static void normalizeForms(DEPTree tree) {
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            node.simplifiedForm = MPLib.normalizeBasic(node.form);
            node.lowerSimplifiedForm = node.simplifiedForm.toLowerCase();
        }
    }

    public static void predictSRL(AbstractPredIdentifier identifier, AbstractSRLabeler labeler, DEPTree tree) {
        identifier.identify(tree);
        tree.initSHeads();
        labeler.label(tree);
    }

    public static void predictSRL(AbstractPredIdentifier identifier, CRolesetClassifier classifier, AbstractSRLabeler labeler, DEPTree tree) {
        identifier.identify(tree);
        classifier.process(tree);
        tree.initSHeads();
        labeler.label(tree);
    }

    public static void addVerbNet(PVMap map, DEPTree tree) {
        ArrayList<String> vnclss;
        PVRoleset pvRoleset;
        int i;
        int size = tree.size();
        PVRoleset[] pvRolesets = new PVRoleset[size];
        for (i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            String rolesetId = node.getFeat("pb");
            if (rolesetId == null) continue;
            pvRoleset = map.getRoleset(rolesetId);
            if (pvRoleset != null) {
                vnclss = new ArrayList<String>(pvRoleset.keySet());
                Collections.sort(vnclss);
                node.addFeat("vn", UTCollection.toString(vnclss, ","));
            }
            pvRolesets[i] = pvRoleset;
        }
        for (i = 1; i < size; ++i) {
            for (DEPArc arc : tree.get(i).getSHeads()) {
                String n;
                pvRoleset = pvRolesets[arc.getNode().id];
                if (pvRoleset == null || !MPLib.containsOnlyDigits(n = arc.getLabel().substring(1, 2))) continue;
                vnclss = new ArrayList(pvRoleset.keySet());
                Collections.sort(vnclss);
                for (String vncls : vnclss) {
                    PVRole pvRole = ((PVRoles)pvRoleset.get(vncls)).getRole(n);
                    if (pvRole == null) continue;
                    arc.appendLabel(pvRole.vntheta);
                }
            }
        }
    }

    public static POSNode[] toPOSNodes(List<String> tokens) {
        int size = tokens.size();
        POSNode[] nodes = new POSNode[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = new POSNode(tokens.get(i));
        }
        return nodes;
    }

    public static DEPTree toDEPTree(POSNode[] nodes) {
        DEPTree tree = new DEPTree();
        int size = nodes.length;
        for (int i = 0; i < size; ++i) {
            tree.add(new DEPNode(i + 1, nodes[i]));
        }
        return tree;
    }
}

