/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.engine;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.component.dep.CDEPPassParser;
import com.googlecode.clearnlp.component.morph.CDefaultMPAnalyzer;
import com.googlecode.clearnlp.component.morph.CEnglishMPAnalyzer;
import com.googlecode.clearnlp.component.pos.CPOSTagger;
import com.googlecode.clearnlp.component.srl.CPredIdentifier;
import com.googlecode.clearnlp.component.srl.CRolesetClassifier;
import com.googlecode.clearnlp.component.srl.CSRLabeler;
import com.googlecode.clearnlp.component.srl.CSenseClassifier;
import com.googlecode.clearnlp.conversion.AbstractC2DConverter;
import com.googlecode.clearnlp.conversion.EnglishC2DConverter;
import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPParser;
import com.googlecode.clearnlp.dependency.srl.AbstractSRLabeler;
import com.googlecode.clearnlp.dependency.srl.SRLabeler;
import com.googlecode.clearnlp.engine.EngineLib;
import com.googlecode.clearnlp.feature.xml.DEPFtrXml;
import com.googlecode.clearnlp.feature.xml.POSFtrXml;
import com.googlecode.clearnlp.feature.xml.SRLFtrXml;
import com.googlecode.clearnlp.headrule.HeadRuleMap;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.morphology.DefaultMPAnalyzer;
import com.googlecode.clearnlp.morphology.EnglishMPAnalyzer;
import com.googlecode.clearnlp.pos.POSTagger;
import com.googlecode.clearnlp.predicate.AbstractPredIdentifier;
import com.googlecode.clearnlp.predicate.PredIdentifier;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.segmentation.EnglishSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.tokenization.EnglishTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EngineGetter
implements EngineLib {
    public static AbstractC2DConverter getC2DConverter(String language, String headruleFile, String mergeLabels) {
        HeadRuleMap headrules = new HeadRuleMap(UTInput.createBufferedFileReader(headruleFile));
        if (language.equals("en")) {
            return new EnglishC2DConverter(headrules, mergeLabels);
        }
        throw new IllegalArgumentException("The requested language '" + language + "' is not currently supported.");
    }

    public static AbstractTokenizer getTokenizer(String language, String dictFile) {
        AbstractTokenizer tokenizer = null;
        try {
            tokenizer = EngineGetter.getTokenizer(language, new FileInputStream(dictFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tokenizer;
    }

    public static AbstractTokenizer getTokenizer(String language, InputStream stream) {
        if (language.equals("en")) {
            return new EnglishTokenizer(new ZipInputStream(stream));
        }
        throw new IllegalArgumentException("The requested language '" + language + "' is not currently supported.");
    }

    public static AbstractSegmenter getSegmenter(String language, AbstractTokenizer tokenizer) {
        if (language.equals("en")) {
            return new EnglishSegmenter(tokenizer);
        }
        throw new IllegalArgumentException("The requested language '" + language + "' is not currently supported.");
    }

    public static AbstractMPAnalyzer getMPAnalyzer(String language, String dictFile) {
        if (language.equals("en")) {
            return new EnglishMPAnalyzer(dictFile);
        }
        return new DefaultMPAnalyzer();
    }

    public static AbstractMPAnalyzer getMPAnalyzer(String language, InputStream stream) {
        if (language.equals("en")) {
            return new EnglishMPAnalyzer(stream);
        }
        return new DefaultMPAnalyzer();
    }

    public static Pair<POSTagger[], Double> getPOSTaggers(String modelFile) throws Exception {
        return EngineGetter.getPOSTaggers(new FileInputStream(modelFile));
    }

    public static Pair<POSTagger[], Double> getPOSTaggers(InputStream stream) throws Exception {
        ZipEntry zEntry;
        ZipInputStream zin = new ZipInputStream(stream);
        POSTagger[] taggers = null;
        double threshold = -1.0;
        POSFtrXml xml = null;
        while ((zEntry = zin.getNextEntry()) != null) {
            String entry = zEntry.getName();
            BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
            if (entry.equals("CONFIGURATION")) {
                taggers = new POSTagger[Integer.parseInt(fin.readLine())];
                threshold = Double.parseDouble(fin.readLine());
                continue;
            }
            if (entry.equals("FEATURE")) {
                xml = new POSFtrXml(EngineGetter.getFeatureTemplates(fin));
                continue;
            }
            if (!entry.startsWith("MODEL")) continue;
            int modId = Integer.parseInt(entry.substring("MODEL".length()));
            taggers[modId] = new POSTagger(xml, fin);
        }
        zin.close();
        return new Pair<Object, Double>(taggers, threshold);
    }

    public static AbstractDEPParser getDEPParser(String modelFile) throws IOException {
        return EngineGetter.getDEPParser(new FileInputStream(modelFile));
    }

    public static AbstractDEPParser getDEPParser(InputStream stream) throws IOException {
        ZipEntry zEntry;
        ZipInputStream zin = new ZipInputStream(stream);
        DEPParser parser = null;
        DEPFtrXml xml = null;
        while ((zEntry = zin.getNextEntry()) != null) {
            String entry = zEntry.getName();
            BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
            if (entry.equals("FEATURE")) {
                xml = new DEPFtrXml(EngineGetter.getFeatureTemplates(fin));
                continue;
            }
            if (!entry.startsWith("MODEL")) continue;
            parser = new DEPParser(xml, fin);
        }
        zin.close();
        return parser;
    }

    public static AbstractPredIdentifier getPredIdentifier(String modelFile) throws IOException {
        return EngineGetter.getPredIdentifier(new FileInputStream(modelFile));
    }

    public static AbstractPredIdentifier getPredIdentifier(InputStream stream) throws IOException {
        ZipEntry zEntry;
        ZipInputStream zin = new ZipInputStream(stream);
        PredIdentifier identifier = null;
        SRLFtrXml xml = null;
        while ((zEntry = zin.getNextEntry()) != null) {
            String entry = zEntry.getName();
            BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
            if (entry.equals("FEATURE")) {
                xml = new SRLFtrXml(EngineGetter.getFeatureTemplates(fin));
                continue;
            }
            if (!entry.startsWith("MODEL")) continue;
            identifier = new PredIdentifier(xml, fin);
        }
        zin.close();
        return identifier;
    }

    public static AbstractComponent getComponent(InputStream stream, String language, String mode) throws IOException {
        ZipInputStream zin = new ZipInputStream(stream);
        if (mode.equals("pos")) {
            return new CPOSTagger(zin);
        }
        if (mode.equals("morph")) {
            return EngineGetter.getCMPAnalyzer(zin, language);
        }
        if (mode.equals("dep")) {
            return new CDEPPassParser(zin);
        }
        if (mode.equals("pred")) {
            return new CPredIdentifier(zin);
        }
        if (mode.equals("role")) {
            return new CRolesetClassifier(zin);
        }
        if (mode.startsWith("sense")) {
            return new CSenseClassifier(zin, mode.substring(mode.lastIndexOf("_") + 1));
        }
        if (mode.equals("srl")) {
            return new CSRLabeler(zin);
        }
        throw new IllegalArgumentException("The requested mode '" + mode + "' is not supported.");
    }

    private static AbstractComponent getCMPAnalyzer(ZipInputStream zin, String language) throws IOException {
        if (language.equals("en")) {
            return new CEnglishMPAnalyzer(zin);
        }
        return new CDefaultMPAnalyzer();
    }

    public static AbstractSRLabeler getSRLabeler(String modelFile) throws Exception {
        return EngineGetter.getSRLabeler(new FileInputStream(modelFile));
    }

    public static AbstractSRLabeler getSRLabeler(InputStream stream) throws Exception {
        ZipEntry zEntry;
        ZipInputStream zin = new ZipInputStream(stream);
        StringModel[] models = new StringModel[2];
        Set<String> sDown = null;
        Set<String> sUp = null;
        SRLFtrXml xml = null;
        while ((zEntry = zin.getNextEntry()) != null) {
            String entry = zEntry.getName();
            BufferedReader fin = new BufferedReader(new InputStreamReader(zin));
            if (entry.equals("FEATURE")) {
                xml = new SRLFtrXml(EngineGetter.getFeatureTemplates(fin));
                continue;
            }
            if (entry.equals("SET_DOWN")) {
                sDown = UTInput.getStringSet(fin);
                continue;
            }
            if (entry.equals("SET_UP")) {
                sUp = UTInput.getStringSet(fin);
                continue;
            }
            if (entry.startsWith("MODEL0")) {
                models[0] = new StringModel(fin);
                continue;
            }
            if (!entry.startsWith("MODEL1")) continue;
            models[1] = new StringModel(fin);
        }
        zin.close();
        return new SRLabeler(xml, models, sDown, sUp);
    }

    static ByteArrayInputStream getFeatureTemplates(BufferedReader fin) throws IOException {
        String line;
        StringBuilder build = new StringBuilder();
        System.out.println("Loading feature templates.");
        while ((line = fin.readLine()) != null) {
            build.append(line);
            build.append("\n");
        }
        return new ByteArrayInputStream(build.toString().getBytes());
    }
}

