/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.engine;

import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.feature.xml.AbstractFtrXml;
import com.googlecode.clearnlp.feature.xml.FtrTemplate;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import java.io.PrintStream;

public abstract class AbstractEngine {
    public static final byte FLAG_LEXICA = 0;
    public static final byte FLAG_TRAIN = 1;
    public static final byte FLAG_PREDICT = 2;
    public static final byte FLAG_BOOST = 3;
    public static final byte FLAG_DEMO = 4;
    protected byte i_flag;

    public AbstractEngine(byte flag) {
        this.i_flag = flag;
    }

    protected StringFeatureVector getFeatureVector(AbstractFtrXml xml) {
        StringFeatureVector vector = new StringFeatureVector();
        for (FtrTemplate template : xml.getFtrTemplates()) {
            this.addFeatures(vector, template);
        }
        return vector;
    }

    private void addFeatures(StringFeatureVector vector, FtrTemplate template) {
        FtrToken[] tokens = template.tokens;
        int size = tokens.length;
        if (template.isSetFeature()) {
            String[][] fields = new String[size][];
            for (int i = 0; i < size; ++i) {
                String[] tmp = this.getFields(tokens[i]);
                if (tmp == null) {
                    return;
                }
                fields[i] = tmp;
            }
            this.addFeatures(vector, template.type, fields, 0, "");
        } else {
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                String field = this.getField(tokens[i]);
                if (field == null) {
                    return;
                }
                if (i > 0) {
                    build.append("_");
                }
                build.append(field);
            }
            vector.addFeature(template.type, build.toString());
        }
    }

    private void addFeatures(StringFeatureVector vector, String type, String[][] fields, int index, String prev) {
        if (index < fields.length) {
            for (String field : fields[index]) {
                if (prev.isEmpty()) {
                    this.addFeatures(vector, type, fields, index + 1, field);
                    continue;
                }
                this.addFeatures(vector, type, fields, index + 1, prev + "_" + field);
            }
        } else {
            vector.addFeature(type, prev);
        }
    }

    protected abstract String getField(FtrToken var1);

    protected abstract String[] getFields(FtrToken var1);

    public abstract void saveModel(PrintStream var1);
}

