/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.AbstractEngine;
import com.googlecode.clearnlp.feature.xml.DEPFtrXml;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import com.googlecode.clearnlp.util.triple.Triple;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDEPParser
extends AbstractEngine {
    protected final String LB_LEFT = "L";
    protected final String LB_RIGHT = "R";
    protected final String LB_NO = "N";
    protected final String LB_SHIFT = "S";
    protected final String LB_REDUCE = "R";
    protected final String LB_PASS = "P";
    protected final String LB_DELIM = "_";
    protected final Pattern P_LABELS = Pattern.compile("_");
    protected final int IDX_ARC = 0;
    protected final int IDX_LIST = 1;
    protected final int IDX_DEPREL = 2;
    protected DEPTree d_tree;
    protected IntOpenHashSet s_reduce;
    protected Set<String> s_punc;
    protected StringIntPair[] g_heads;
    protected DEPNode[] lm_deps;
    protected DEPNode[] rm_deps;
    protected int i_lambda;
    protected int i_beta;
    protected int n_trans;
    protected PrintStream f_trans;

    public AbstractDEPParser(byte flag) {
        super(flag);
    }

    public abstract void loadModel(BufferedReader var1);

    @Override
    public abstract void saveModel(PrintStream var1);

    protected abstract String[] getLabels();

    protected abstract void postProcessAux(DEPNode var1, int var2, Triple<DEPNode, String, Double> var3);

    public int getNumTransitions() {
        return this.n_trans;
    }

    public void parse(DEPTree tree) {
        this.init(tree);
        this.parseAux();
        if (this.i_flag == 2) {
            this.postProcess();
        } else if (this.i_flag == 4) {
            this.f_trans.println();
        }
    }

    protected void init(DEPTree tree) {
        this.d_tree = tree;
        this.n_trans = 0;
        this.i_lambda = 0;
        this.i_beta = 1;
        this.s_reduce = new IntOpenHashSet();
        if (this.i_flag != 2) {
            this.g_heads = this.d_tree.getHeads();
        }
        this.initArcs();
        tree.clearHeads();
    }

    private void initArcs() {
        int size = this.d_tree.size();
        this.lm_deps = new DEPNode[size];
        this.rm_deps = new DEPNode[size];
    }

    protected void parseAux() {
        int size = this.d_tree.size();
        while (this.i_beta < size) {
            if (this.i_lambda < 0) {
                this.noShift();
                continue;
            }
            DEPNode lambda = this.d_tree.get(this.i_lambda);
            DEPNode beta = this.d_tree.get(this.i_beta);
            String[] labels = this.getLabels();
            ++this.n_trans;
            if (labels[0].equals("L")) {
                if (this.i_lambda == 0) {
                    this.noShift();
                    continue;
                }
                if (beta.isDescendentOf(lambda)) {
                    this.noPass();
                    continue;
                }
                if (labels[1].equals("R")) {
                    this.leftReduce(lambda, beta, labels[2]);
                    continue;
                }
                this.leftPass(lambda, beta, labels[2]);
                continue;
            }
            if (labels[0].equals("R")) {
                if (lambda.isDescendentOf(beta)) {
                    this.noPass();
                    continue;
                }
                if (labels[1].equals("S")) {
                    this.rightShift(lambda, beta, labels[2]);
                    continue;
                }
                this.rightPass(lambda, beta, labels[2]);
                continue;
            }
            if (labels[1].equals("S")) {
                this.noShift();
                continue;
            }
            if (labels[1].equals("R") && lambda.hasHead()) {
                this.noReduce();
                continue;
            }
            this.noPass();
        }
    }

    protected String[] getGoldLabels() {
        String[] labels = this.getGoldLabelArc();
        labels[1] = labels[0].equals("L") ? (this.isGoldReduce(true) ? "R" : "P") : (labels[0].equals("R") ? (this.isGoldShift() ? "S" : "P") : (this.isGoldShift() ? "S" : (this.isGoldReduce(false) ? "R" : "P")));
        return labels;
    }

    private String[] getGoldLabelArc() {
        StringIntPair head = this.g_heads[this.i_lambda];
        String[] labels = new String[3];
        if (head.i == this.i_beta) {
            labels[0] = "L";
            labels[2] = head.s;
            return labels;
        }
        head = this.g_heads[this.i_beta];
        if (head.i == this.i_lambda) {
            labels[0] = "R";
            labels[2] = head.s;
            return labels;
        }
        labels[0] = "N";
        labels[2] = "";
        return labels;
    }

    private boolean isGoldShift() {
        if (this.g_heads[this.i_beta].i < this.i_lambda) {
            return false;
        }
        for (int i = this.i_lambda - 1; i > 0; --i) {
            if (this.s_reduce.contains(i) || this.g_heads[i].i != this.i_beta) continue;
            return false;
        }
        return true;
    }

    private boolean isGoldReduce(boolean hasHead) {
        if (!hasHead && !this.d_tree.get(this.i_lambda).hasHead()) {
            return false;
        }
        int size = this.d_tree.size();
        for (int i = this.i_beta + 1; i < size; ++i) {
            if (this.g_heads[i].i != this.i_lambda) continue;
            return false;
        }
        return true;
    }

    protected void leftReduce(DEPNode lambda, DEPNode beta, String deprel) {
        if (this.i_flag == 4) {
            this.printState("Left-Reduce", this.i_lambda + " <-" + deprel + "- " + this.i_beta);
        }
        this.leftArc(lambda, beta, deprel);
        this.reduce();
    }

    protected void leftPass(DEPNode lambda, DEPNode beta, String deprel) {
        if (this.i_flag == 4) {
            this.printState("Left-Pass", this.i_lambda + " <-" + deprel + "- " + this.i_beta);
        }
        this.leftArc(lambda, beta, deprel);
        this.pass();
    }

    protected void rightShift(DEPNode lambda, DEPNode beta, String deprel) {
        if (this.i_flag == 4) {
            this.printState("Right-Shift", this.i_lambda + " -" + deprel + "-> " + this.i_beta);
        }
        this.rightArc(lambda, beta, deprel);
        this.shift();
    }

    protected void rightPass(DEPNode lambda, DEPNode beta, String deprel) {
        if (this.i_flag == 4) {
            this.printState("Right-Pass", this.i_lambda + " -" + deprel + "-> " + this.i_beta);
        }
        this.rightArc(lambda, beta, deprel);
        this.pass();
    }

    protected void noShift() {
        if (this.i_flag == 4) {
            this.printState("No-Shift", null);
        }
        this.shift();
    }

    protected void noReduce() {
        if (this.i_flag == 4) {
            this.printState("No-Reduce", null);
        }
        this.reduce();
    }

    protected void noPass() {
        if (this.i_flag == 4) {
            this.printState("No-Pass", null);
        }
        this.pass();
    }

    private void leftArc(DEPNode lambda, DEPNode beta, String deprel) {
        lambda.setHead(beta, deprel);
        this.lm_deps[this.i_beta] = lambda;
    }

    private void rightArc(DEPNode lambda, DEPNode beta, String deprel) {
        beta.setHead(lambda, deprel);
        this.rm_deps[this.i_lambda] = beta;
    }

    private void shift() {
        this.i_lambda = this.i_beta++;
    }

    private void reduce() {
        this.s_reduce.add(this.i_lambda);
        this.passAux();
    }

    private void pass() {
        this.passAux();
    }

    private void passAux() {
        int i;
        for (i = this.i_lambda - 1; i >= 0; --i) {
            if (this.s_reduce.contains(i)) continue;
            this.i_lambda = i;
            return;
        }
        this.i_lambda = i;
    }

    protected void postProcess() {
        Triple<Object, Object, Double> max = new Triple<Object, Object, Double>(null, null, -1.0);
        DEPNode root = this.d_tree.get(0);
        int size = this.d_tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = this.d_tree.get(i);
            if (node.hasHead()) continue;
            max.set(root, "root", -1.0);
            this.postProcessAux(node, -1, max);
            this.postProcessAux(node, 1, max);
            node.setHead((DEPNode)max.o1, (String)max.o2);
        }
    }

    protected void printState(String trans, String deprel) {
        StringBuilder build = new StringBuilder();
        build.append(trans);
        build.append("\t");
        build.append("[");
        if (this.i_lambda >= 0) {
            if (this.i_lambda > 0) {
                build.append("L1|");
            }
            build.append(this.i_lambda);
        }
        build.append("]");
        build.append("\t");
        build.append("[");
        int lambda2 = this.getFirstLambda2();
        if (this.i_beta - lambda2 > 0) {
            build.append(lambda2);
            if (this.i_beta - lambda2 > 1) {
                build.append("|L2");
            }
        }
        build.append("]");
        build.append("\t");
        build.append("[");
        if (this.i_beta < this.d_tree.size()) {
            build.append(this.i_beta);
            if (this.i_beta + 1 < this.d_tree.size()) {
                build.append("|B");
            }
        }
        build.append("]");
        build.append("\t");
        if (deprel != null) {
            build.append(deprel);
        }
        this.f_trans.println(build.toString());
    }

    private int getFirstLambda2() {
        for (int i = this.i_lambda + 1; i < this.i_beta; ++i) {
            if (this.s_reduce.contains(i)) continue;
            return i;
        }
        return this.d_tree.size();
    }

    @Override
    protected String getField(FtrToken token) {
        DEPNode node = this.getNode(token);
        if (node == null) {
            return null;
        }
        if (token.isField("f")) {
            return node.form;
        }
        if (token.isField("m")) {
            return node.lemma;
        }
        if (token.isField("p")) {
            return node.pos;
        }
        if (token.isField("d")) {
            return node.getLabel();
        }
        if (token.isField("lnpl")) {
            return this.getLeftNearestPunctuation(0, this.i_lambda);
        }
        if (token.isField("rnpl")) {
            return this.getRightNearestPunctuation(this.i_lambda, this.i_beta);
        }
        if (token.isField("lnpb")) {
            return this.getLeftNearestPunctuation(this.i_lambda, this.i_beta);
        }
        if (token.isField("rnpb")) {
            return this.getRightNearestPunctuation(this.i_beta, this.d_tree.size());
        }
        Matcher m = DEPFtrXml.P_FEAT.matcher(token.field);
        if (m.find()) {
            return node.getFeat(m.group(1));
        }
        m = DEPFtrXml.P_BOOLEAN.matcher(token.field);
        if (m.find()) {
            int field = Integer.parseInt(m.group(1));
            int size = this.d_tree.size();
            switch (field) {
                case 0: {
                    return this.i_lambda == 1 ? token.field : null;
                }
                case 1: {
                    return this.i_beta == size - 1 ? token.field : null;
                }
                case 2: {
                    return this.i_lambda + 1 == this.i_beta ? token.field : null;
                }
            }
        }
        return null;
    }

    @Override
    protected String[] getFields(FtrToken token) {
        return null;
    }

    private DEPNode getNode(FtrToken token) {
        DEPNode node = null;
        switch (token.source) {
            case 's': {
                node = this.getNodeStack(token);
                break;
            }
            case 'l': {
                node = this.getNodeLambda(token);
                break;
            }
            case 'b': {
                node = this.getNodeBeta(token);
            }
        }
        if (node == null) {
            return null;
        }
        if (token.relation != null) {
            if (token.isRelation("h")) {
                node = node.getHead();
            } else if (token.isRelation("lmd")) {
                node = this.lm_deps[node.id];
            } else if (token.isRelation("rmd")) {
                node = this.rm_deps[node.id];
            }
        }
        return node;
    }

    private DEPNode getNodeStack(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_lambda);
        }
        int offset = Math.abs(token.offset);
        int dir = token.offset < 0 ? -1 : 1;
        for (int i = this.i_lambda + dir; 0 < i && i < this.i_beta; i += dir) {
            if (this.s_reduce.contains(i) || --offset != 0) continue;
            return this.d_tree.get(i);
        }
        return null;
    }

    private DEPNode getNodeLambda(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_lambda);
        }
        int cIndex = this.i_lambda + token.offset;
        if (0 < cIndex && cIndex < this.i_beta) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }

    private DEPNode getNodeBeta(FtrToken token) {
        if (token.offset == 0) {
            return this.d_tree.get(this.i_beta);
        }
        int cIndex = this.i_beta + token.offset;
        if (this.i_lambda < cIndex && cIndex < this.d_tree.size()) {
            return this.d_tree.get(cIndex);
        }
        return null;
    }

    private String getLeftNearestPunctuation(int lIdx, int rIdx) {
        for (int i = rIdx - 1; i > lIdx; --i) {
            String form = this.d_tree.get((int)i).form;
            if (!this.s_punc.contains(form)) continue;
            return form;
        }
        return null;
    }

    private String getRightNearestPunctuation(int lIdx, int rIdx) {
        for (int i = lIdx + 1; i < rIdx; ++i) {
            String form = this.d_tree.get((int)i).form;
            if (!this.s_punc.contains(form)) continue;
            return form;
        }
        return null;
    }
}

