/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import com.googlecode.clearnlp.segmentation.AbstractSegmenter;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.List;

public class DemoNLPDecoder {
    final String language = "en";

    public DemoNLPDecoder(String dictFile, String posModelFile, String depModelFile, String predModelFile, String roleModelFile, String vnModelFile, String srlModelFile, String inputFile, String outputFile) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", new FileInputStream(dictFile));
        AbstractComponent tagger = EngineGetter.getComponent(new FileInputStream(posModelFile), "en", "pos");
        AbstractComponent analyzer = EngineGetter.getComponent(new FileInputStream(dictFile), "en", "morph");
        AbstractComponent parser = EngineGetter.getComponent(new FileInputStream(depModelFile), "en", "dep");
        AbstractComponent identifier = EngineGetter.getComponent(new FileInputStream(predModelFile), "en", "pred");
        AbstractComponent classifier = EngineGetter.getComponent(new FileInputStream(roleModelFile), "en", "role");
        AbstractComponent verbnet = EngineGetter.getComponent(new FileInputStream(vnModelFile), "en", "sense_vn");
        AbstractComponent labeler = EngineGetter.getComponent(new FileInputStream(srlModelFile), "en", "srl");
        AbstractComponent[] components = new AbstractComponent[]{tagger, analyzer, parser, identifier, classifier, verbnet, labeler};
        String sentence = "I'd like to meet Dr. Choi.";
        this.process(tokenizer, components, sentence);
        this.process(tokenizer, components, UTInput.createBufferedFileReader(inputFile), UTOutput.createPrintBufferedFileStream(outputFile));
    }

    public void process(AbstractTokenizer tokenizer, AbstractComponent[] components, String sentence) {
        NLPDecode nlp = new NLPDecode();
        DEPTree tree = nlp.toDEPTree(tokenizer.getTokens(sentence));
        for (AbstractComponent component : components) {
            component.process(tree);
        }
        System.out.println(tree.toStringSRL() + "\n");
    }

    public void process(AbstractTokenizer tokenizer, AbstractComponent[] components, BufferedReader reader, PrintStream fout) {
        AbstractSegmenter segmenter = EngineGetter.getSegmenter("en", tokenizer);
        NLPDecode nlp = new NLPDecode();
        for (List<String> tokens : segmenter.getSentences(reader)) {
            DEPTree tree = nlp.toDEPTree(tokens);
            for (AbstractComponent component : components) {
                component.process(tree);
            }
            fout.println(tree.toStringSRL() + "\n");
        }
        fout.close();
    }

    public static void main(String[] args) {
        String dictFile = args[0];
        String posModelFile = args[1];
        String depModelFile = args[2];
        String predModelFile = args[3];
        String roleModelFile = args[4];
        String vnModelFile = args[5];
        String srlModelFile = args[6];
        String inputFile = args[7];
        String outputFile = args[8];
        try {
            new DemoNLPDecoder(dictFile, posModelFile, depModelFile, predModelFile, roleModelFile, vnModelFile, srlModelFile, inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

