/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.constituent;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.propbank.PBLoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CTTree {
    private CTNode nd_root;
    private List<CTNode> ls_termainals;
    private List<CTNode> ls_tokens;
    private IntObjectOpenHashMap<List<CTNode>> mp_nulls;

    public CTTree(CTNode root) {
        this.nd_root = root;
        this.setTerminals();
        this.linkCoIndexedEmtpyCategories();
    }

    private void setTerminals() {
        ArrayList<CTNode> terminals = new ArrayList<CTNode>();
        ArrayList<CTNode> tokens = new ArrayList<CTNode>();
        this.setTerminalsAux(this.nd_root, terminals, tokens);
        this.ls_termainals = Collections.unmodifiableList(terminals);
        this.ls_tokens = Collections.unmodifiableList(tokens);
    }

    private void setTerminalsAux(CTNode curr, List<CTNode> terminals, List<CTNode> tokens) {
        if (curr.isPhrase()) {
            for (CTNode child : curr.ls_children) {
                this.setTerminalsAux(child, terminals, tokens);
            }
        } else {
            curr.i_terminalId = terminals.size();
            terminals.add(curr);
            if (!curr.isEmptyCategory()) {
                curr.i_tokenId = tokens.size();
                tokens.add(curr);
            }
        }
    }

    private void linkCoIndexedEmtpyCategories() {
        this.mp_nulls = new IntObjectOpenHashMap();
        for (CTNode node : this.ls_termainals) {
            List<CTNode> list;
            int idx;
            if (!node.isEmptyCategory() || (idx = node.form.lastIndexOf("-")) < 0) continue;
            int coIndex = Integer.parseInt(node.form.substring(idx + 1));
            node.antecedent = this.getCoIndexedAntecedent(coIndex);
            if (node.antecedent == null) continue;
            if (this.mp_nulls.containsKey(coIndex)) {
                list = (List)this.mp_nulls.get(coIndex);
            } else {
                list = new ArrayList();
                this.mp_nulls.put(coIndex, list);
            }
            list.add(node);
        }
    }

    public void setPBLocs() {
        for (CTNode node : this.ls_termainals) {
            int terminalId = node.i_terminalId;
            int height = 0;
            node.pb_loc = new PBLoc(terminalId, height);
            while (node.parent != null && node.parent.pb_loc == null) {
                node = node.parent;
                node.pb_loc = new PBLoc(terminalId, ++height);
            }
        }
    }

    public CTNode getRoot() {
        return this.nd_root;
    }

    public CTNode getNode(int terminalId, int height) {
        CTNode node = this.getTerminal(terminalId);
        for (int i = height; i > 0; --i) {
            node = node.parent;
        }
        return node;
    }

    public CTNode getNode(PBLoc loc) {
        return this.getNode(loc.terminalId, loc.height);
    }

    public CTNode getTerminal(int terminalId) {
        return this.ls_termainals.get(terminalId);
    }

    public List<CTNode> getTerminals() {
        return this.ls_termainals;
    }

    public CTNode getToken(int tokenId) {
        return this.ls_tokens.get(tokenId);
    }

    public List<CTNode> getTokens() {
        return this.ls_tokens;
    }

    public CTNode getCoIndexedAntecedent(int coIndex) {
        return this.getCoIndexedAntecedentAux(coIndex, this.nd_root);
    }

    private CTNode getCoIndexedAntecedentAux(int coIndex, CTNode curr) {
        if (curr.coIndex == coIndex) {
            return curr;
        }
        if (curr.gapIndex == coIndex) {
            int t = curr.coIndex;
            curr.coIndex = curr.gapIndex;
            curr.gapIndex = t;
            return curr;
        }
        for (CTNode child : curr.getChildren()) {
            CTNode ante = this.getCoIndexedAntecedentAux(coIndex, child);
            if (ante == null) continue;
            return ante;
        }
        return null;
    }

    public List<CTNode> getCoIndexedEmptyCategories(int coIndex) {
        return (List)this.mp_nulls.get(coIndex);
    }

    public boolean isRange(int terminalId, int height) {
        if (terminalId < 0 || terminalId >= this.ls_termainals.size()) {
            return false;
        }
        CTNode node = this.ls_termainals.get(terminalId);
        for (int i = height; i > 0; --i) {
            if (node.parent == null) {
                return false;
            }
            node = node.parent;
        }
        return true;
    }

    public boolean isRange(PBLoc loc) {
        return this.isRange(loc.terminalId, loc.height);
    }

    public String toForms() {
        return this.toForms(true, " ");
    }

    public String toForms(boolean includeNulls, String delim) {
        StringBuilder build = new StringBuilder();
        if (includeNulls) {
            for (CTNode node : this.ls_termainals) {
                build.append(delim);
                build.append(node.form);
            }
        } else {
            for (CTNode node : this.ls_tokens) {
                build.append(delim);
                build.append(node.form);
            }
        }
        return build.length() == 0 ? "" : build.substring(delim.length());
    }

    public String toCoNLLPOS(boolean includeNulls, String delim) {
        StringBuilder build = new StringBuilder();
        if (includeNulls) {
            for (CTNode node : this.ls_termainals) {
                build.append(node.form);
                build.append(delim);
                build.append(node.pTag);
                build.append("\n");
            }
        } else {
            for (CTNode node : this.ls_tokens) {
                build.append(node.form);
                build.append(delim);
                build.append(node.pTag);
                build.append("\n");
            }
        }
        return build.toString();
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toStringLine() {
        return this.nd_root.toStringLine();
    }

    public String toString(boolean ... args) {
        return this.nd_root.toString(args);
    }
}

