/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.constituent;

import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.StringTokenizer;

public class CTReader {
    private LineNumberReader f_in;
    private Deque<String> d_tokens;

    public CTReader() {
    }

    public CTReader(BufferedReader in) {
        this.open(in);
    }

    public void open(BufferedReader in) {
        this.f_in = new LineNumberReader(in);
        this.d_tokens = new ArrayDeque<String>();
    }

    public void close() {
        if (this.f_in != null) {
            try {
                this.f_in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public CTTree nextTree() {
        CTNode root;
        String token = this.nextToken();
        if (token == null) {
            return null;
        }
        if (!token.equals("(")) {
            System.err.println("Error: \"" + token + "\" found, \"(\" expected - line " + this.f_in.getLineNumber());
            return null;
        }
        CTNode curr = root = new CTNode("TOP", null);
        int nBrackets = 1;
        int startLine = this.f_in.getLineNumber();
        while ((token = this.nextToken()) != null) {
            if (nBrackets == 1 && token.equals("TOP")) continue;
            if (token.equals("(")) {
                String tags = this.nextToken();
                CTNode node = new CTNode(tags);
                curr.addChild(node);
                curr = node;
                ++nBrackets;
            } else if (token.equals(")")) {
                curr = curr.parent;
                --nBrackets;
            } else {
                curr.form = token;
            }
            if (nBrackets != 0) continue;
            CTTree tree = new CTTree(root);
            return tree;
        }
        System.err.println("Error: brackets mismatch - starting line " + startLine);
        return null;
    }

    public CTTree nextTree(int treeId) {
        CTTree tree = null;
        for (int i = 0; i <= treeId; ++i) {
            tree = this.nextTree();
        }
        return tree;
    }

    private String nextToken() {
        if (this.d_tokens.isEmpty()) {
            String line = null;
            try {
                line = this.f_in.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (line == null) {
                return null;
            }
            if ((line = line.trim()).isEmpty()) {
                return this.nextToken();
            }
            StringTokenizer tok = new StringTokenizer(line, "() \t\n\r\f", true);
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken().trim();
                if (str.isEmpty()) continue;
                this.d_tokens.add(str);
            }
        }
        return this.d_tokens.pop();
    }
}

