/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component;

import com.googlecode.clearnlp.classification.model.ONStringModel;
import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.FtrTemplate;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public abstract class AbstractStatisticalComponent
extends AbstractComponent {
    protected StringTrainSpace[] s_spaces;
    protected StringModel[] s_models;
    protected JointFtrXml[] f_xmls;
    protected DEPTree d_tree;
    protected int t_size;

    public AbstractStatisticalComponent() {
    }

    public AbstractStatisticalComponent(JointFtrXml[] xmls) {
        this.i_flag = 0;
        this.f_xmls = xmls;
    }

    public AbstractStatisticalComponent(JointFtrXml[] xmls, StringTrainSpace[] spaces, Object[] lexica) {
        this.i_flag = 1;
        this.f_xmls = xmls;
        this.s_spaces = spaces;
        this.initLexia(lexica);
    }

    public AbstractStatisticalComponent(JointFtrXml[] xmls, StringModel[] models, Object[] lexica) {
        this.i_flag = (byte)4;
        this.f_xmls = xmls;
        this.s_models = models;
        this.initLexia(lexica);
    }

    public AbstractStatisticalComponent(ZipInputStream zin) {
        this.i_flag = (byte)2;
        this.loadModels(zin);
    }

    public AbstractStatisticalComponent(JointFtrXml[] xmls, StringTrainSpace[] spaces, StringModel[] models, Object[] lexica) {
        this.i_flag = (byte)3;
        this.f_xmls = xmls;
        this.s_spaces = spaces;
        this.s_models = models;
        this.initLexia(lexica);
    }

    protected abstract void initLexia(Object[] var1);

    public abstract void loadModels(ZipInputStream var1);

    protected void loadDefaultConfiguration(ZipInputStream zin) throws Exception {
        BufferedReader fin = UTInput.createBufferedReader(zin);
        int mSize = Integer.parseInt(fin.readLine());
        System.out.println("Loading configuration.");
        this.s_models = new StringModel[mSize];
    }

    protected ByteArrayInputStream loadFeatureTemplates(ZipInputStream zin, int index) throws Exception {
        System.out.println("Loading feature templates.");
        BufferedReader fin = UTInput.createBufferedReader(zin);
        ByteArrayInputStream template = this.getFeatureTemplates(fin);
        this.f_xmls[index] = new JointFtrXml(template);
        return template;
    }

    protected ByteArrayInputStream getFeatureTemplates(BufferedReader fin) throws IOException {
        String line;
        StringBuilder build = new StringBuilder();
        while ((line = fin.readLine()) != null) {
            build.append(line);
            build.append("\n");
        }
        return new ByteArrayInputStream(build.toString().getBytes());
    }

    protected void loadStatisticalModels(ZipInputStream zin, int index) throws Exception {
        BufferedReader fin = UTInput.createBufferedReader(zin);
        this.s_models[index] = new StringModel(fin);
    }

    protected void loadOnlineModels(ZipInputStream zin, int index, double alpha, double rho) throws Exception {
        BufferedReader fin = UTInput.createBufferedReader(zin);
        this.s_models[index] = new ONStringModel(fin, alpha, rho);
    }

    public abstract void saveModels(ZipOutputStream var1);

    protected void saveDefaultConfiguration(ZipOutputStream zout, String entryName) throws Exception {
        zout.putNextEntry(new ZipEntry(entryName));
        PrintStream fout = UTOutput.createPrintBufferedStream(zout);
        System.out.println("Saving configuration.");
        fout.println(this.s_models.length);
        fout.flush();
        zout.closeEntry();
    }

    protected void saveFeatureTemplates(ZipOutputStream zout, String entryName) throws Exception {
        int size = this.f_xmls.length;
        System.out.println("Saving feature templates.");
        for (int i = 0; i < size; ++i) {
            zout.putNextEntry(new ZipEntry(entryName + i));
            PrintStream fout = UTOutput.createPrintBufferedStream(zout);
            IOUtils.copy((InputStream)UTInput.toInputStream(this.f_xmls[i].toString()), (OutputStream)fout);
            fout.flush();
            zout.closeEntry();
        }
    }

    protected void saveStatisticalModels(ZipOutputStream zout, String entryName) throws Exception {
        int size = this.s_models.length;
        for (int i = 0; i < size; ++i) {
            zout.putNextEntry(new ZipEntry(entryName + i));
            PrintStream fout = UTOutput.createPrintBufferedStream(zout);
            this.s_models[i].save(fout);
            fout.flush();
            zout.closeEntry();
        }
    }

    public StringTrainSpace[] getTrainSpaces() {
        return this.s_spaces;
    }

    public StringModel[] getModels() {
        return this.s_models;
    }

    public abstract Object[] getLexica();

    public abstract void countAccuracy(int[] var1);

    protected abstract String getField(FtrToken var1);

    protected abstract String[] getFields(FtrToken var1);

    protected StringFeatureVector getFeatureVector(JointFtrXml xml) {
        StringFeatureVector vector = new StringFeatureVector();
        for (FtrTemplate template : xml.getFtrTemplates()) {
            this.addFeatures(vector, template);
        }
        return vector;
    }

    private void addFeatures(StringFeatureVector vector, FtrTemplate template) {
        FtrToken[] tokens = template.tokens;
        int size = tokens.length;
        if (template.isSetFeature()) {
            String[][] fields = new String[size][];
            for (int i = 0; i < size; ++i) {
                String[] tmp = this.getFields(tokens[i]);
                if (tmp == null) {
                    return;
                }
                fields[i] = tmp;
            }
            this.addFeatures(vector, template.type, fields, 0, "");
        } else {
            StringBuilder build = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                String field = this.getField(tokens[i]);
                if (field == null) {
                    return;
                }
                if (i > 0) {
                    build.append("_");
                }
                build.append(field);
            }
            vector.addFeature(template.type, build.toString());
        }
    }

    private void addFeatures(StringFeatureVector vector, String type, String[][] fields, int index, String prev) {
        if (index < fields.length) {
            for (String field : fields[index]) {
                if (prev.isEmpty()) {
                    this.addFeatures(vector, type, fields, index + 1, field);
                    continue;
                }
                this.addFeatures(vector, type, fields, index + 1, prev + "_" + field);
            }
        } else {
            vector.addFeature(type, prev);
        }
    }

    protected List<Pair<String, StringFeatureVector>> getTrimmedInstances(List<Pair<String, StringFeatureVector>> insts) {
        ArrayList<Pair<String, StringFeatureVector>> nInsts = new ArrayList<Pair<String, StringFeatureVector>>();
        HashSet<String> set = new HashSet<String>();
        for (Pair<String, StringFeatureVector> p : insts) {
            String key = (String)p.o1 + " " + ((StringFeatureVector)p.o2).toString();
            if (set.contains(key)) continue;
            nInsts.add(p);
            set.add(key);
        }
        return nInsts;
    }
}

