/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.train;

import com.googlecode.clearnlp.classification.model.SparseModel;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.util.pair.Pair;
import java.util.ArrayList;
import java.util.List;

public class SparseTrainSpace
extends AbstractTrainSpace {
    private SparseModel s_model;
    private List<String> s_ys;

    public SparseTrainSpace(boolean hasWeight) {
        super(new SparseModel(), hasWeight);
        this.s_model = (SparseModel)this.m_model;
        this.s_ys = new ArrayList<String>();
    }

    public void addInstance(String label, SparseFeatureVector vector) {
        int[] x = vector.getIndices();
        this.s_model.addLabel(label);
        this.s_model.addFeatures(x);
        this.s_ys.add(label);
        this.a_xs.add(x);
        if (this.b_weight) {
            this.a_vs.add(vector.getWeights());
        }
    }

    @Override
    public void addInstance(String line) {
        Pair<String, SparseFeatureVector> instance = SparseTrainSpace.toInstance(line, this.b_weight);
        this.addInstance((String)instance.o1, (SparseFeatureVector)instance.o2);
    }

    @Override
    public void build(boolean clearInstances) {
        System.out.println("Building:");
        this.s_model.initLabelArray();
        for (String label : this.s_ys) {
            this.a_ys.add(this.s_model.getLabelIndex(label));
        }
        System.out.println("- # of labels   : " + this.s_model.getLabelSize());
        System.out.println("- # of features : " + this.s_model.getFeatureSize());
        System.out.println("- # of instances: " + this.a_ys.size());
        if (clearInstances) {
            this.s_ys.clear();
        }
    }

    @Override
    public void build() {
        this.build(true);
    }

    public static Pair<String, SparseFeatureVector> toInstance(String line, boolean hasWeight) {
        String[] tmp = line.split(" ");
        String label = tmp[0];
        SparseFeatureVector vector = new SparseFeatureVector(hasWeight);
        int size = tmp.length;
        for (int i = 1; i < size; ++i) {
            vector.addFeature(tmp[i]);
        }
        return new Pair<String, SparseFeatureVector>(label, vector);
    }
}

