/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.algorithm;

import com.carrotsearch.hppc.IntArrayList;
import com.googlecode.clearnlp.classification.algorithm.AbstractAlgorithm;
import com.googlecode.clearnlp.classification.train.AbstractTrainSpace;
import com.googlecode.clearnlp.util.UTArray;
import java.util.ArrayList;
import java.util.Random;

public class LiblinearL2LR
extends AbstractAlgorithm {
    private double d_cost;
    private double d_eps;
    private double d_bias;

    public LiblinearL2LR(double cost, double eps, double bias) {
        this.d_cost = cost;
        this.d_eps = eps;
        this.d_bias = bias;
    }

    @Override
    public double[] getWeight(AbstractTrainSpace space, int currLabel) {
        int iter;
        int j;
        int[] xi;
        double d;
        int i;
        Random rand = new Random(1L);
        int MAX_ITER = 1000;
        int MAX_ITER_NEWTON = 100;
        int N = space.getInstanceSize();
        int D = space.getFeatureSize();
        double eta = 0.1;
        double innereps_min = Math.min(1.0E-8, this.d_eps);
        IntArrayList ys = space.getYs();
        ArrayList<int[]> xs = space.getXs();
        ArrayList<double[]> vs = space.getVs();
        double[] xTx = new double[N];
        double[] alpha = new double[2 * N];
        double[] weight = new double[D];
        int[] index = new int[N];
        byte[] aY = new byte[N];
        double[] vi = null;
        double innereps = 0.01;
        double[] upper_bound = new double[]{this.d_cost, 0.0, this.d_cost};
        for (i = 0; i < N; ++i) {
            index[i] = i;
            aY[i] = ys.get(i) == currLabel ? 1 : -1;
            alpha[2 * i] = Math.min(0.001 * upper_bound[this.GETI(aY, i)], 1.0E-8);
            alpha[2 * i + 1] = upper_bound[this.GETI(aY, i)] - alpha[2 * i];
            d = (double)aY[i] * alpha[2 * i];
            xi = xs.get(i);
            if (space.hasWeight()) {
                vi = vs.get(i);
            }
            if (this.d_bias > 0.0) {
                int n = i;
                xTx[n] = xTx[n] + this.d_bias * this.d_bias;
                weight[0] = weight[0] + d * this.d_bias;
            }
            for (j = 0; j < xi.length; ++j) {
                if (space.hasWeight()) {
                    int n = i;
                    xTx[n] = xTx[n] + vi[j] * vi[j];
                    int n2 = xi[j];
                    weight[n2] = weight[n2] + d * vi[j];
                    continue;
                }
                int n = i;
                xTx[n] = xTx[n] + 1.0;
                int n3 = xi[j];
                weight[n3] = weight[n3] + d;
            }
        }
        for (iter = 0; iter < 1000; ++iter) {
            for (i = 0; i < N; ++i) {
                j = i + rand.nextInt(N - i);
                UTArray.swap(index, i, j);
            }
            int iter_newton = 0;
            double Gmax = 0.0;
            for (int s = 0; s < N; ++s) {
                int iter_inner;
                double alpha_old;
                double z;
                double ywTx;
                i = index[s];
                byte yi = aY[i];
                xi = xs.get(i);
                double xisq = xTx[i];
                double C = upper_bound[this.GETI(aY, i)];
                double d2 = ywTx = this.d_bias > 0.0 ? weight[0] * this.d_bias : 0.0;
                if (space.hasWeight()) {
                    vi = vs.get(i);
                    for (j = 0; j < xi.length; ++j) {
                        ywTx += weight[xi[j]] * vi[j];
                    }
                } else {
                    for (j = 0; j < xi.length; ++j) {
                        ywTx += weight[xi[j]];
                    }
                }
                double a = xisq;
                double b = ywTx *= (double)yi;
                int ind1 = 2 * i;
                int ind2 = 2 * i + 1;
                int sign = 1;
                if (0.5 * a * (alpha[ind2] - alpha[ind1]) + b < 0.0) {
                    ind1 = 2 * i + 1;
                    ind2 = 2 * i;
                    sign = -1;
                }
                if (C - (z = (alpha_old = alpha[ind1])) < 0.5 * C) {
                    z *= 0.1;
                }
                double gp = a * (z - alpha_old) + (double)sign * b + Math.log(z / (C - z));
                Gmax = Math.max(Gmax, Math.abs(gp));
                for (iter_inner = 0; iter_inner <= 100 && !(Math.abs(gp) < innereps); ++iter_inner) {
                    double gpp = a + C / (C - z) / z;
                    double tmpz = z - gp / gpp;
                    z = tmpz <= 0.0 ? (z *= 0.1) : tmpz;
                    gp = a * (z - alpha_old) + (double)sign * b + Math.log(z / (C - z));
                    ++iter_newton;
                }
                if (iter_inner <= 0) continue;
                alpha[ind1] = z;
                alpha[ind2] = C - z;
                d = (double)sign * (z - alpha_old) * (double)yi;
                if (this.d_bias > 0.0) {
                    weight[0] = weight[0] + d * this.d_bias;
                }
                for (j = 0; j < xi.length; ++j) {
                    if (space.hasWeight()) {
                        int n = xi[j];
                        weight[n] = weight[n] + d * vi[j];
                        continue;
                    }
                    int n = xi[j];
                    weight[n] = weight[n] + d;
                }
            }
            if (Gmax < this.d_eps) break;
            if (iter_newton > N / 10) continue;
            innereps = Math.max(innereps_min, 0.1 * innereps);
        }
        double v = 0.0;
        for (i = 0; i < D; ++i) {
            v += weight[i] * weight[i];
        }
        v *= 0.5;
        for (i = 0; i < N; ++i) {
            v += alpha[2 * i] * Math.log(alpha[2 * i]) + alpha[2 * i + 1] * Math.log(alpha[2 * i + 1]) - upper_bound[this.GETI(aY, i)] * Math.log(upper_bound[this.GETI(aY, i)]);
        }
        StringBuilder build = new StringBuilder();
        build.append("- label = ");
        build.append(currLabel);
        build.append(": iter = ");
        build.append(iter);
        build.append(", obj-value = ");
        build.append(v);
        System.out.println(build.toString());
        return weight;
    }
}

