/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.resources.PlatformDetector;
import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class RuntimeProvider {
    public static final String MODE_EXECUTABLE = "executable";
    private boolean installed;
    private File workspace;
    private String baseLocation;
    private String platform;

    public RuntimeProvider(String aBaseLocation) {
        this.setBaseLocation(aBaseLocation);
        this.platform = new PlatformDetector().getPlatformId();
    }

    public void setBaseLocation(String aBaseLocation) {
        this.baseLocation = aBaseLocation;
    }

    public Properties getManifest() throws IOException {
        String mfl = this.baseLocation;
        if (!mfl.endsWith("/")) {
            mfl = mfl + "/";
        }
        URL manifestUrl = ResourceUtils.resolveLocation(this.baseLocation + this.platform + "/manifest.properties", this, null);
        return PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(manifestUrl));
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public File getFile(String aFilename) throws IOException {
        this.install();
        File file = new File(this.getWorkspace(), aFilename);
        if (!file.exists()) {
            throw new FileNotFoundException("File not found in workspace: [" + aFilename + "]");
        }
        return file;
    }

    public File getWorkspace() throws IOException {
        if (this.workspace == null) {
            this.workspace = File.createTempFile("dkpro", "runtime");
            FileUtils.forceDelete((File)this.workspace);
            FileUtils.forceMkdir((File)this.workspace);
            this.workspace.deleteOnExit();
        }
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws IOException {
        if (this.installed) {
            return;
        }
        Properties manifest = this.getManifest();
        for (String filename : manifest.stringPropertyNames()) {
            URL source = ResourceUtils.resolveLocation(this.baseLocation + this.platform + "/" + filename, this, null);
            File target = new File(this.getWorkspace(), filename);
            InputStream is = null;
            FileOutputStream os = null;
            try {
                is = source.openStream();
                os = new FileOutputStream(target);
                IOUtils.copyLarge((InputStream)is, (OutputStream)os);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
            if (MODE_EXECUTABLE.equals(manifest.getProperty(filename))) {
                target.setExecutable(true);
            }
            target.deleteOnExit();
        }
        this.installed = true;
    }

    public void uninstall() {
        if (this.workspace != null) {
            FileUtils.deleteQuietly((File)this.workspace);
            this.workspace = null;
            this.installed = false;
        }
    }

    protected void finalize() throws Throwable {
        this.uninstall();
    }
}

