/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.resources.CompressionMethod;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.io.FileUtils;

public class CompressionUtils {
    public static InputStream getInputStream(String aLocation, InputStream aStream) throws IOException {
        String lcLocation = aLocation.toLowerCase();
        if (lcLocation.endsWith(CompressionMethod.GZIP.getExtension())) {
            return new GZIPInputStream(aStream);
        }
        if (lcLocation.endsWith(CompressionMethod.BZIP2.getExtension()) || lcLocation.endsWith(".bzip2")) {
            return new BZip2CompressorInputStream(aStream);
        }
        if (lcLocation.endsWith(CompressionMethod.XZ.getExtension())) {
            return new XZCompressorInputStream(aStream);
        }
        return aStream;
    }

    public static OutputStream getOutputStream(File aFile) throws IOException {
        if (aFile.getParentFile() != null) {
            FileUtils.forceMkdir((File)aFile.getParentFile());
        }
        String lcFilename = aFile.getName().toLowerCase();
        OutputStream os = new FileOutputStream(aFile);
        if (lcFilename.endsWith(CompressionMethod.GZIP.getExtension())) {
            os = new GZIPOutputStream(os);
        } else if (lcFilename.endsWith(CompressionMethod.BZIP2.getExtension()) || lcFilename.endsWith(".bzip2")) {
            os = new BZip2CompressorOutputStream(os);
        } else if (lcFilename.endsWith(CompressionMethod.XZ.getExtension())) {
            os = new XZCompressorOutputStream(os);
        }
        return os;
    }
}

