/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.ser.BeanSerializerFactory;
import org.codehaus.jackson.map.type.ClassKey;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSerializerFactory
extends BeanSerializerFactory {
    HashMap<ClassKey, JsonSerializer<?>> _directClassMappings = null;
    JsonSerializer<?> _enumSerializerOverride;
    HashMap<ClassKey, JsonSerializer<?>> _transitiveClassMappings = null;
    HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings = null;

    public <T> void addGenericMapping(Class<? extends T> type, JsonSerializer<T> ser) {
        ClassKey key = new ClassKey(type);
        if (type.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(key, ser);
        } else {
            if (this._transitiveClassMappings == null) {
                this._transitiveClassMappings = new HashMap();
            }
            this._transitiveClassMappings.put(key, ser);
        }
    }

    public <T> void addSpecificMapping(Class<? extends T> forClass, JsonSerializer<T> ser) {
        ClassKey key = new ClassKey(forClass);
        if (forClass.isInterface()) {
            throw new IllegalArgumentException("Can not add specific mapping for an interface (" + forClass.getName() + ")");
        }
        if (Modifier.isAbstract(forClass.getModifiers())) {
            throw new IllegalArgumentException("Can not add specific mapping for an abstract class (" + forClass.getName() + ")");
        }
        if (this._directClassMappings == null) {
            this._directClassMappings = new HashMap();
        }
        this._directClassMappings.put(key, ser);
    }

    public void setEnumSerializer(JsonSerializer<?> enumSer) {
        this._enumSerializerOverride = enumSer;
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type, SerializationConfig config) {
        JsonSerializer<?> ser = this.findCustomSerializer(type, config);
        if (ser != null) {
            return ser;
        }
        return super.createSerializer(type, config);
    }

    @Override
    public JsonSerializer<Object> createSerializer(JavaType type, SerializationConfig config) {
        JsonSerializer<Object> ser = this.findCustomSerializer(type.getRawClass(), config);
        if (ser != null) {
            return ser;
        }
        return super.createSerializer(type, config);
    }

    protected JsonSerializer<?> findCustomSerializer(Class<?> type, SerializationConfig config) {
        Class<?> curr;
        JsonSerializer<?> ser = null;
        ClassKey key = new ClassKey(type);
        if (this._directClassMappings != null && (ser = this._directClassMappings.get(key)) != null) {
            return ser;
        }
        if (type.isEnum() && this._enumSerializerOverride != null) {
            return this._enumSerializerOverride;
        }
        if (this._transitiveClassMappings != null) {
            for (curr = type; curr != null; curr = curr.getSuperclass()) {
                key.reset(curr);
                ser = this._transitiveClassMappings.get(key);
                if (ser == null) continue;
                return ser;
            }
        }
        if (this._interfaceMappings != null) {
            for (curr = type; curr != null; curr = curr.getSuperclass()) {
                for (Class<?> iface : curr.getInterfaces()) {
                    key.reset(iface);
                    ser = this._interfaceMappings.get(key);
                    if (ser == null) continue;
                    return ser;
                }
            }
        }
        return null;
    }
}

