/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.propbank.util;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.corpus.propbank.util.PropbankRelation;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.util.AnnotationUtil;

@Beta
public class PropbankSplitRelation
extends PropbankRelation {
    protected List<PropbankRelation> relations = new ArrayList<PropbankRelation>();

    public static PropbankSplitRelation fromString(String s) {
        String[] fields;
        PropbankSplitRelation rel = new PropbankSplitRelation();
        for (String field : fields = s.split(",")) {
            rel.addRelation(PropbankRelation.fromString(field));
        }
        return rel;
    }

    public List<PropbankRelation> getRelations() {
        return this.relations;
    }

    public void addRelation(PropbankRelation rel) {
        this.relations.add(rel);
    }

    @Override
    public Annotation convert(JCas view, TopTreebankNode topNode) {
        Annotation annotation = new Annotation(view);
        ArrayList<Annotation> subAnnotations = new ArrayList<Annotation>();
        for (PropbankRelation rel : this.relations) {
            subAnnotations.add(rel.convert(view, topNode));
        }
        int[] span = AnnotationUtil.getAnnotationsExtent(subAnnotations);
        annotation.setBegin(span[0]);
        annotation.setEnd(span[1]);
        annotation.addToIndexes();
        return annotation;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (PropbankRelation rel : this.getRelations()) {
            if (!first) {
                buffer.append(",");
            }
            buffer.append(rel.toString());
            first = false;
        }
        return buffer.toString();
    }
}

