/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight.model;

import com.google.common.annotations.Beta;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import org.cleartk.ml.svmlight.model.Kernel;
import org.cleartk.ml.svmlight.model.LinearKernel;
import org.cleartk.ml.svmlight.model.PolynomialKernel;
import org.cleartk.ml.svmlight.model.RbfKernel;
import org.cleartk.ml.svmlight.model.SigmoidKernel;
import org.cleartk.ml.svmlight.model.UnsupportedKernelError;
import org.cleartk.ml.tksvmlight.TreeFeatureVector;
import org.cleartk.ml.tksvmlight.model.CompositeKernel;
import org.cleartk.ml.tksvmlight.model.TkSupportVector;
import org.cleartk.ml.tksvmlight.model.TreeKernel;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;
import org.cleartk.ml.util.featurevector.SparseFeatureVector;

@Beta
public class TreeKernelSvmModel {
    String version;
    CompositeKernel kernel = null;
    double bias;
    TkSupportVector[] supportVectors = null;

    public double evaluate(TreeFeatureVector fv) {
        double result = -this.bias;
        for (TkSupportVector sv : this.supportVectors) {
            result += sv.getAlpha() * this.kernel.evaluate(fv, sv.tfv);
        }
        return result;
    }

    public static TreeKernelSvmModel fromFile(File modelFile) throws IOException {
        FileInputStream modelStream = new FileInputStream(modelFile);
        TreeKernelSvmModel model = TreeKernelSvmModel.fromInputStream(modelStream);
        ((InputStream)modelStream).close();
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TreeKernelSvmModel fromInputStream(InputStream modelStream) throws IOException {
        String buffer;
        TreeKernelSvmModel model = new TreeKernelSvmModel();
        TkSvmLightReader in = new TkSvmLightReader(modelStream);
        LinearKernel featKernel = null;
        TreeKernel treeKernel = null;
        model.version = buffer = in.readLine();
        int ktype = Integer.parseInt(in.readLine());
        int kpar_degree = Integer.parseInt(in.readLine());
        double kpar_gamma = Double.parseDouble(in.readLine());
        double kpar_s = Double.parseDouble(in.readLine());
        double kpar_c = Double.parseDouble(in.readLine());
        in.readLine();
        double lambda = Double.parseDouble(in.readLine());
        double multiplier = Double.parseDouble(in.readLine());
        String comboOperator = in.readLine();
        in.readLine();
        int fkType = Integer.parseInt(in.readLine());
        int tkType = (int)Double.parseDouble(in.readLine());
        int norm = Integer.parseInt(in.readLine());
        in.readLine();
        String treeSeqMethod = in.readLine();
        block19: for (int kCode : new int[]{ktype, fkType}) {
            if (featKernel != null) break;
            switch (kCode) {
                case 0: {
                    featKernel = new LinearKernel();
                    continue block19;
                }
                case 1: {
                    featKernel = new PolynomialKernel(kpar_s, kpar_c, kpar_degree);
                    continue block19;
                }
                case 2: {
                    featKernel = new RbfKernel(kpar_gamma);
                    continue block19;
                }
                case 3: {
                    featKernel = new SigmoidKernel(kpar_s, kpar_c);
                    continue block19;
                }
                case 5: {
                    continue block19;
                }
                default: {
                    throw new UnsupportedKernelError();
                }
            }
        }
        CompositeKernel.ComboOperator operator = null;
        if (ktype == 5) {
            TreeKernel.KernelType kernelType;
            TreeKernel.ForestSumMethod sumMethod = treeSeqMethod.equals("S") ? TreeKernel.ForestSumMethod.SEQUENTIAL : TreeKernel.ForestSumMethod.ALL_PAIRS;
            switch (tkType) {
                case 0: {
                    kernelType = TreeKernel.KernelType.SUBTREE;
                    break;
                }
                case 1: {
                    kernelType = TreeKernel.KernelType.SUBSET;
                    break;
                }
                case 2: {
                    kernelType = TreeKernel.KernelType.SUBSET_BOW;
                    break;
                }
                case 3: {
                    kernelType = TreeKernel.KernelType.PARTIAL;
                    break;
                }
                default: {
                    throw new UnsupportedKernelError();
                }
            }
            boolean normalize = norm == 1 || norm == 3;
            treeKernel = new TreeKernel(lambda, sumMethod, kernelType, normalize);
            if (comboOperator.equals("+")) {
                operator = CompositeKernel.ComboOperator.SUM;
            } else if (comboOperator.equals("*")) {
                operator = CompositeKernel.ComboOperator.PRODUCT;
            } else if (comboOperator.equals("T")) {
                operator = CompositeKernel.ComboOperator.TREE_ONLY;
            } else {
                if (!comboOperator.equals("V")) throw new UnsupportedKernelError();
                operator = CompositeKernel.ComboOperator.VECTOR_ONLY;
            }
        } else {
            operator = CompositeKernel.ComboOperator.VECTOR_ONLY;
        }
        CompositeKernel.Normalize normal = CompositeKernel.Normalize.BOTH;
        switch (norm) {
            case 0: {
                normal = CompositeKernel.Normalize.NEITHER;
                break;
            }
            case 1: {
                normal = CompositeKernel.Normalize.TREE;
                break;
            }
            case 2: {
                normal = CompositeKernel.Normalize.VECTOR;
                break;
            }
            case 3: {
                normal = CompositeKernel.Normalize.BOTH;
                break;
            }
            default: {
                throw new UnsupportedKernelError();
            }
        }
        model.kernel = new CompositeKernel((Kernel)featKernel, treeKernel, operator, multiplier, normal);
        in.readLine();
        in.readLine();
        int numSVs = Integer.valueOf(in.readLine()) - 1;
        model.bias = Double.valueOf(in.readLine());
        in.inSVs = true;
        model.supportVectors = new TkSupportVector[numSVs];
        for (int i = 0; i < numSVs; ++i) {
            model.supportVectors[i] = TreeKernelSvmModel.readSV(in);
        }
        return model;
    }

    private static TkSupportVector readSV(TkSvmLightReader in) throws IOException {
        String line = in.readLine();
        int firstWhitespace = line.indexOf(32);
        double alpha_y = Double.parseDouble(line.substring(0, firstWhitespace));
        String treesAndVecs = line.substring(firstWhitespace).trim();
        String treeSect = null;
        String vectSect = null;
        int etInd = treesAndVecs.indexOf("|ET|");
        if (etInd >= 0) {
            treeSect = treesAndVecs.substring(0, etInd - 1).trim();
            if (treesAndVecs.substring(etInd).contains("|EV|")) {
                vectSect = treesAndVecs.substring(etInd + 4);
            }
        } else {
            vectSect = treesAndVecs;
        }
        LinkedHashMap<String, String> trees = new LinkedHashMap<String, String>();
        if (treeSect != null) {
            String[] subtrees = treeSect.substring(5).split("\\|BT\\|");
            for (int i = 0; i < subtrees.length; ++i) {
                trees.put("TK_" + i, subtrees[i].replaceAll("\\((\\S+)\\)", "$1"));
            }
        }
        SparseFeatureVector fv = new SparseFeatureVector();
        if (vectSect != null) {
            String[] features = vectSect.trim().split(" +");
            for (int i = 0; i < features.length - 1; ++i) {
                String[] parts = features[i].split(":");
                int featureIndex = Integer.valueOf(parts[0]);
                double featureValue = Double.valueOf(parts[1]);
                try {
                    fv.set(featureIndex, featureValue);
                    continue;
                }
                catch (InvalidFeatureVectorValueException e) {
                    throw new IOException(e);
                }
            }
        }
        TreeFeatureVector tfv = new TreeFeatureVector();
        tfv.setFeatures((FeatureVector)fv);
        tfv.setTrees(trees);
        return new TkSupportVector(alpha_y, tfv);
    }

    private static class TkSvmLightReader {
        BufferedReader reader;
        boolean inSVs = false;

        TkSvmLightReader(InputStream modelStream) {
            this.reader = new BufferedReader(new InputStreamReader(modelStream));
        }

        String readLine() throws IOException {
            String line = this.reader.readLine().trim();
            if (this.inSVs) {
                return line;
            }
            return line.split("#")[0].trim();
        }
    }
}

