/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.tksvmlight.model;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SimpleDepTree {
    public String cat;
    public ArrayList<SimpleDepTree> children;
    public SimpleDepTree parent = null;
    static Pattern ptPatt = Pattern.compile("\\(([^ (]+) +([^ )]+)\\)");
    static Pattern orphanPatt = Pattern.compile("\\(([^ (]+) \\)");

    public SimpleDepTree(String s) {
        this(s, null);
    }

    public SimpleDepTree(String s, SimpleDepTree p) {
        this.cat = SimpleDepTree.escapeCat(s);
        this.children = new ArrayList();
        this.parent = p;
    }

    public static String escapeCat(String c) {
        c = c.replaceAll("\\(", "LPAREN");
        c = c.replaceAll("\\)", "RPAREN");
        return c;
    }

    public void addChild(SimpleDepTree t) {
        this.children.add(t);
    }

    private static String[] splitChildren(String s) {
        ArrayList<String> children = new ArrayList<String>();
        char[] chars = s.toCharArray();
        int numParens = 0;
        int startIndex = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '(') {
                if (++numParens != 1) continue;
                startIndex = i;
                continue;
            }
            if (chars[i] != ')') continue;
            if (--numParens == 0) {
                children.add(s.substring(startIndex, i + 1));
                continue;
            }
            if (numParens < 0) break;
        }
        return children.toArray(new String[0]);
    }

    static SimpleDepTree fromString(String string) {
        SimpleDepTree tree = null;
        Matcher pretermMatcher = ptPatt.matcher(string);
        Matcher orphanMatcher = orphanPatt.matcher(string);
        if (pretermMatcher.matches()) {
            tree = new SimpleDepTree(pretermMatcher.group(1));
            SimpleDepTree leaf = new SimpleDepTree(pretermMatcher.group(2));
            tree.addChild(leaf);
            leaf.parent = tree;
        } else if (orphanMatcher.matches()) {
            tree = new SimpleDepTree(orphanMatcher.group(1));
        } else {
            int firstWS = string.indexOf(32);
            tree = new SimpleDepTree(string.substring(1, firstWS));
            String[] childStrings = SimpleDepTree.splitChildren(string.substring(firstWS + 1, string.length() - 1));
            for (int i = 0; i < childStrings.length; ++i) {
                SimpleDepTree child = SimpleDepTree.fromString(childStrings[i]);
                child.parent = tree;
                tree.addChild(child);
            }
        }
        return tree;
    }

    public final boolean isLeaf() {
        return this.children.size() == 0;
    }
}

