/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.util.ThreadInterruptedException;

public class RateLimiter {
    private volatile double mbPerSec;
    private volatile double nsPerByte;
    private volatile long lastNS;

    public RateLimiter(double mbPerSec) {
        this.setMbPerSec(mbPerSec);
    }

    public void setMbPerSec(double mbPerSec) {
        this.mbPerSec = mbPerSec;
        this.nsPerByte = 1.0E9 / (1048576.0 * mbPerSec);
    }

    public double getMbPerSec() {
        return this.mbPerSec;
    }

    public void pause(long bytes) {
        long pauseNS;
        if (bytes == 1L) {
            return;
        }
        long targetNS = this.lastNS += (long)((double)bytes * this.nsPerByte);
        long curNS = System.nanoTime();
        if (this.lastNS < curNS) {
            this.lastNS = curNS;
        }
        while ((pauseNS = targetNS - curNS) > 0L) {
            try {
                Thread.sleep((int)(pauseNS / 1000000L), (int)(pauseNS % 1000000L));
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
            curNS = System.nanoTime();
        }
    }
}

