/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

public class ParentPtrTree {
    private int[] parents;
    private int size;

    public ParentPtrTree(int sz) {
        this.size = sz;
        this.parents = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.parents[i] = -1;
        }
    }

    public ParentPtrTree(int[][] pairs) {
        int i;
        int sz = 0;
        for (i = 0; i < pairs.length; ++i) {
            if (pairs[i][0] > sz) {
                sz = pairs[i][0];
            }
            if (pairs[i][1] <= sz) continue;
            sz = pairs[i][1];
        }
        this.size = sz;
        this.parents = new int[this.size];
        for (i = 0; i < this.size; ++i) {
            this.parents[i] = -1;
        }
        for (i = 0; i < pairs.length; ++i) {
            if (!this.differ(pairs[i][0] - 1, pairs[i][1] - 1)) continue;
            this.union(pairs[i][0] - 1, pairs[i][1] - 1);
        }
    }

    public int getSize() {
        return this.size;
    }

    private int find(int n) {
        if (this.parents[n] == -1) {
            return n;
        }
        this.parents[n] = this.find(this.parents[n]);
        return this.parents[n];
    }

    public void union(int a, int b) {
        int root2;
        int root1 = this.find(a);
        if (root1 != (root2 = this.find(b))) {
            this.parents[root2] = root1;
        }
    }

    public boolean differ(int a, int b) {
        return this.find(a) != this.find(b);
    }

    public int equivCls(int[] ec) {
        for (int i = 0; i < this.size; ++i) {
            ec[i] = -1;
        }
        int classes = -1;
        for (int i = 0; i < this.size; ++i) {
            if (ec[i] >= 0) continue;
            int r = this.find(i);
            if (ec[r] == -1) {
                ec[r] = ++classes;
            }
            int j = i;
            while (j != r) {
                ec[j] = ec[r];
                j = this.parents[j];
            }
        }
        return classes + 1;
    }

    public void print() {
        int i;
        for (i = 0; i < this.size; ++i) {
            System.out.print(this.parents[i] + " ");
        }
        System.out.println();
        for (i = 0; i < this.size; ++i) {
            System.out.println(i + 1 + ":" + this.find(i));
        }
    }
}

