/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.extractors;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class ContinuousBag
implements CleartkExtractor.Context {
    private CleartkExtractor.Context[] contexts;
    private String name = null;
    private Map<String, double[]> vectors = null;
    private int dims;

    public ContinuousBag(File vecFile, CleartkExtractor.Context ... contexts) throws FileNotFoundException {
        this.contexts = contexts;
        this.vectors = this.readVectorFile(vecFile);
        this.name = Feature.createName((String[])new String[]{"ContinuousBag"});
    }

    private Map<String, double[]> readVectorFile(File vecFile) throws FileNotFoundException {
        HashMap<String, double[]> vectorMap = new HashMap<String, double[]>();
        try (Scanner scanner = new Scanner(vecFile);){
            while (scanner.hasNextLine()) {
                String[] termVec = scanner.nextLine().trim().split("\\s+");
                if (termVec.length == 2) continue;
                this.dims = termVec.length - 1;
                double[] vector = new double[this.dims];
                for (int i = 0; i < this.dims; ++i) {
                    vector[i] = Double.parseDouble(termVec[i + 1]);
                }
                vectorMap.put(termVec[0], vector);
            }
        }
        return vectorMap;
    }

    public String getName() {
        return this.name;
    }

    public <SEARCH_T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, CleartkExtractor.Bounds bounds, Class<SEARCH_T> annotationClass, FeatureExtractor1<SEARCH_T> extractor) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        for (CleartkExtractor.Context context : this.contexts) {
            double[] contextVec = new double[this.dims];
            int numComponents = 0;
            for (Feature feature : context.extract(jCas, focusAnnotation, bounds, annotationClass, extractor)) {
                if (!this.vectors.containsKey(feature.getValue())) continue;
                double[] featVec = this.vectors.get(feature.getValue().toString().toLowerCase());
                ContinuousBag.addToVector(contextVec, featVec);
                ++numComponents;
            }
            if (numComponents <= 0) continue;
            for (int i = 0; i < this.dims; ++i) {
                feats.add(new Feature(Feature.createName((String[])new String[]{this.name, context.getName(), String.valueOf(i)}), (Object)(contextVec[i] / (double)numComponents)));
            }
        }
        return feats;
    }

    private static void addToVector(double[] vec1, double[] vec2) {
        for (int i = 0; i < vec1.length; ++i) {
            int n = i;
            vec1[n] = vec1[n] + vec2[i];
        }
    }

    public static class Surrounding
    implements CleartkExtractor.Context {
        public String getName() {
            return "Surrounding";
        }

        public <SEARCH_T extends Annotation> List<Feature> extract(JCas jCas, Annotation focusAnnotation, CleartkExtractor.Bounds bounds, Class<SEARCH_T> annotationClass, FeatureExtractor1<SEARCH_T> extractor) throws CleartkExtractorException {
            ArrayList<Feature> feats = new ArrayList<Feature>();
            return feats;
        }
    }
}

