/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSList;
import org.cleartk.ml.Feature;

public class MentionClusterDistanceFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        int minDistance = Integer.MAX_VALUE;
        int neMinDistance = Integer.MAX_VALUE;
        int sentMinDistance = Integer.MAX_VALUE;
        for (Markable member : JCasUtil.select((FSList)cluster.getMembers(), Markable.class)) {
            int dist = JCasUtil.selectBetween(BaseToken.class, (AnnotationFS)member, (AnnotationFS)mention).size();
            minDistance = Math.min(minDistance, dist);
            int neDist = JCasUtil.selectBetween(Markable.class, (AnnotationFS)member, (AnnotationFS)mention).size();
            neMinDistance = Math.min(neMinDistance, neDist);
            int sentDist = JCasUtil.selectBetween(Sentence.class, (AnnotationFS)member, (AnnotationFS)mention).size();
            sentMinDistance = Math.min(sentMinDistance, sentDist);
        }
        feats.add(new Feature("MinTokenDistance", (Object)((double)minDistance / 4000.0)));
        feats.add(new Feature("MinMarkableDistance", (Object)((double)neMinDistance / 900.0)));
        feats.add(new Feature("MinSentDistance", (Object)((double)sentMinDistance / 350.0)));
        return feats;
    }
}

