/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.coreference.ae.MarkableHeadTreeCreator;
import org.apache.ctakes.coreference.ae.features.StringMatchingFeatureExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.utils.struct.MapFactory;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterDepHeadExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jCas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        String headWord;
        Markable member;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ConllDependencyNode mentionHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)mention);
        HashSet<String> memberHeads = new HashSet<String>();
        HashSet<String> memberPaths = new HashSet<String>();
        Iterator iterator = new ListIterable(cluster.getMembers()).iterator();
        while (iterator.hasNext() && (member = (Markable)iterator.next()).getBegin() <= mention.getEnd()) {
            ConllDependencyNode memberHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)member);
            if (memberHead == null) continue;
            String headWord2 = memberHead.getCoveredText().toLowerCase();
            memberHeads.add(headWord2);
            memberPaths.add(memberHead.getDeprel());
        }
        if (mentionHead != null && memberHeads.contains(headWord = mentionHead.getCoveredText().toLowerCase()) && !StringMatchingFeatureExtractor.isPronoun(mention)) {
            feats.add(new Feature("ClusterHeadMatchesMentionHead", (Object)true));
        }
        return feats;
    }

    public List<Feature> extract(JCas jCas, Markable mention) throws CleartkExtractorException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ConllDependencyNode mentionHead = (ConllDependencyNode)MapFactory.get((String)MarkableHeadTreeCreator.getKey(jCas), (TOP)mention);
        if (mentionHead != null) {
            feats.add(new Feature("MentionRel", (Object)mentionHead.getDeprel()));
        }
        return feats;
    }
}

