/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import com.google.common.collect.HashMultiset;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ctakes.constituency.parser.util.TreeUtils;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="Coreference Score Writer", description="Writes scores of system coreference chains compared to chains in a Gold View.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.MARKABLE, PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
public class CoreferenceChainScoringOutput
extends JCasAnnotator_ImplBase {
    @ConfigurationParameter(name="OutputDirectory", mandatory=true, description="Name of chain file in CoNLL format")
    private String outputFilename;
    private PrintWriter out = null;
    private PrintWriter icOut = null;
    public static final String PARAM_GOLD_VIEW_NAME = "GoldViewName";
    @ConfigurationParameter(name="GoldViewName", mandatory=false, description="Name of gold view in jcas")
    private String goldViewName = null;
    boolean isGold;
    private int docNum = 0;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this.out = new PrintWriter(this.outputFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ResourceInitializationException((Throwable)e);
        }
        if (this.goldViewName != null) {
            this.isGold = true;
        } else {
            this.isGold = false;
            try {
                this.icOut = new PrintWriter(this.outputFilename + ".icarus");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        File filename = new File(ViewUriUtil.getURI((JCas)jCas));
        JCas chainsCas = null;
        try {
            chainsCas = this.goldViewName != null ? jCas.getView(this.goldViewName) : jCas;
        }
        catch (CASException e) {
            e.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        int chainNum = 1;
        HashMap<Annotation, Integer> ent2chain = new HashMap<Annotation, Integer>();
        if (this.isGold) {
            System.out.println("\nGold chains:");
        } else {
            this.icOut.println(String.format("#begin document (%s); part 000", filename.getPath()));
            System.out.println("\nSystem chains:");
        }
        Collection rels = JCasUtil.select((JCas)chainsCas, CollectionTextRelation.class);
        if (rels.size() == 0) {
            return;
        }
        for (CollectionTextRelation chain : rels) {
            FSList members = chain.getMembers();
            if (members instanceof NonEmptyFSList && ((NonEmptyFSList)members).getTail() instanceof EmptyFSList) continue;
            while (members instanceof NonEmptyFSList) {
                TOP head = ((NonEmptyFSList)members).getHead();
                Annotation mention = null;
                mention = head instanceof Annotation ? (Annotation)head : ((RelationArgument)head).getArgument();
                ent2chain.put(mention, chainNum);
                members = ((NonEmptyFSList)members).getTail();
                System.out.print("Mention: " + mention.getCoveredText().replace("\n", "<CR>"));
                System.out.print(" (" + mention.getBegin() + ", " + mention.getEnd() + ")");
                System.out.print("  ----->    ");
            }
            System.out.println();
            ++chainNum;
        }
        this.out.println("#begin document (" + filename.getPath() + "); part 000");
        ArrayList tokens = new ArrayList(JCasUtil.select((JCas)jCas, BaseToken.class));
        HashMultiset endSet = HashMultiset.create();
        int tokenId = 0;
        int sentId = 0;
        BaseToken nextToken = (BaseToken)tokens.get(0);
        for (int i = 0; i < tokens.size(); ++i) {
            int ind;
            Object markable2;
            boolean endSentToken = false;
            BaseToken token = nextToken;
            if (i + 1 < tokens.size() && ((nextToken = (BaseToken)tokens.get(i + 1)) instanceof NewlineToken || token.getCoveredText().equals(".") && endSet.size() <= 0)) {
                endSentToken = true;
            }
            if (token instanceof NewlineToken) continue;
            int lastInd = token.getEnd();
            if (token.getCoveredText().length() > 1 && token.getCoveredText().endsWith(".")) {
                lastInd = token.getEnd() - 1;
            }
            ArrayList markables = new ArrayList(JCasUtil.selectCovering((JCas)chainsCas, Markable.class, (int)token.getBegin(), (int)lastInd));
            ArrayList<Annotation> startMention = new ArrayList<Annotation>();
            HashMultiset endMention = HashMultiset.create();
            ArrayList wholeMention = new ArrayList();
            for (Object markable2 : markables) {
                if (!ent2chain.containsKey(markable2)) continue;
                if (markable2.getBegin() == token.getBegin()) {
                    if (markable2.getEnd() == token.getEnd()) {
                        wholeMention.add(ent2chain.get(markable2));
                    } else {
                        startMention.add((Annotation)markable2);
                    }
                } else if (markable2.getEnd() <= token.getEnd()) {
                    if (endMention.contains(ent2chain.get(markable2))) {
                        System.err.println("There is a duplicate element -- should be handled by multiset");
                    }
                    if (markable2.getEnd() < token.getEnd()) {
                        System.err.println("There is a markable that ends in the middle of a token!");
                    }
                    endMention.add(ent2chain.get(markable2));
                }
                if (this.isGold) continue;
                this.icOut.println(String.format("%d-%d-%d\n", sentId, markable2.getBegin(), markable2.getEnd()));
            }
            this.out.print(filename.getPath());
            this.out.print('\t');
            this.out.print(this.docNum);
            this.out.print('\t');
            this.out.print(tokenId++);
            this.out.print('\t');
            this.out.print(token instanceof NewlineToken ? "Newline" : TreeUtils.escapePunct((String)token.getCoveredText()));
            this.out.print('\t');
            this.out.print(token.getPartOfSpeech());
            this.out.print('\t');
            if (tokenId == 1) {
                this.out.print("(NOPARSE*");
                if (endSentToken) {
                    this.out.print(")");
                }
            } else if (endSentToken) {
                this.out.print("*)");
            } else {
                this.out.print("*");
            }
            this.out.print('\t');
            this.out.print('-');
            this.out.print('\t');
            this.out.print('-');
            this.out.print('\t');
            this.out.print('-');
            this.out.print('\t');
            this.out.print('-');
            this.out.print('\t');
            this.out.print('*');
            this.out.print('\t');
            StringBuffer buff = new StringBuffer();
            markable2 = endMention.iterator();
            while (markable2.hasNext()) {
                ind = (Integer)markable2.next();
                if (endSet.contains((Object)ind)) {
                    buff.append(ind);
                    buff.append(')');
                    buff.append('|');
                }
                endSet.remove((Object)ind);
            }
            markable2 = wholeMention.iterator();
            while (markable2.hasNext()) {
                ind = (Integer)markable2.next();
                buff.append('(');
                buff.append(ind);
                buff.append(')');
                buff.append('|');
            }
            while (startMention.size() > 0) {
                Annotation latestEnd = null;
                for (int j = 0; j < startMention.size(); ++j) {
                    if (latestEnd != null && ((Annotation)startMention.get(j)).getEnd() <= latestEnd.getEnd()) continue;
                    latestEnd = (Annotation)startMention.get(j);
                }
                startMention.remove(latestEnd);
                int ind2 = (Integer)ent2chain.get(latestEnd);
                buff.append('(');
                buff.append(ind2);
                buff.append('|');
                endSet.add((Object)ind2);
            }
            if (endSentToken && endSet.size() > 0) {
                System.err.println("Error! There are opened markables that never closed! Putting them on the end of the sentence.");
                Iterator iterator = endSet.iterator();
                while (iterator.hasNext()) {
                    int ind3 = (Integer)iterator.next();
                    buff.append(ind3);
                    buff.append(')');
                    buff.append('|');
                }
                endSet.clear();
            }
            if (buff.length() > 0) {
                this.out.println(buff.substring(0, buff.length() - 1));
            } else {
                this.out.println("_");
            }
            if (!endSentToken) continue;
            this.out.println();
            tokenId = 0;
            ++sentId;
        }
        if (!this.isGold) {
            this.icOut.println("#end document");
        }
        this.out.println("#end document " + filename.getPath());
        this.out.flush();
        ++this.docNum;
    }
}

