/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.AttributeElement;
import com.icesoft.faces.webapp.parser.TagToTagClassElement;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

final class NameRule
extends Rule {
    private Hashtable componentMap;
    private Writer faceletsTaglibXmlWriter;
    private String currentNamespace;
    private static final Log log = LogFactory.getLog(NameRule.class);

    public NameRule(Hashtable map, Writer writer) {
        this.componentMap = map;
        this.faceletsTaglibXmlWriter = writer;
        this.currentNamespace = null;
    }

    public void begin(Attributes attributes) throws Exception {
    }

    public void end(String namespace, String name) {
        if (name.equals("uri")) {
            if (this.faceletsTaglibXmlWriter != null) {
                try {
                    boolean namespaceChanged;
                    String ns = this.digester.peek().toString();
                    boolean bl = namespaceChanged = ns != null && ns.length() > 0 && (this.currentNamespace == null || !this.currentNamespace.equals(ns));
                    if (namespaceChanged) {
                        this.currentNamespace = ns;
                        String nsOutput = "\t<namespace>" + this.currentNamespace + "</namespace>\n";
                        this.faceletsTaglibXmlWriter.write(nsOutput);
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Problem writing ns to eclipse taglib.xml", (Throwable)e);
                }
            }
            return;
        }
        TagToTagClassElement elem = (TagToTagClassElement)this.digester.peek();
        if (this.componentMap.get(elem.getTagName()) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Duplicate Tag " + elem.getTagName() + " not processed"));
            }
            return;
        }
        this.componentMap.put(elem.getTagName(), elem.getTagClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding " + elem.getTagName() + ": " + elem.getTagClass()));
        }
        if (this.faceletsTaglibXmlWriter != null) {
            try {
                String tagName = elem.getTagName();
                String tagClassStr = elem.getTagClass();
                if (tagName != null && tagClassStr != null && tagClassStr.indexOf("com.icesoft") >= 0) {
                    if (tagName.equals("tabChangeListener")) {
                        StringBuffer sb = new StringBuffer(256);
                        sb.append("\t<tag>\n\t\t<tag-name>");
                        sb.append(tagName);
                        sb.append("</tag-name>\n\t\t<handler-class>");
                        sb.append("com.icesoft.faces.facelets.TabChangeListenerHandler");
                        sb.append("</handler-class>\n\t</tag>\n");
                        this.faceletsTaglibXmlWriter.write(sb.toString());
                    } else {
                        Class<?> tagClass = Class.forName(tagClassStr);
                        Object tagObj = tagClass.newInstance();
                        Method getComponentTypeMeth = tagClass.getMethod("getComponentType", new Class[0]);
                        String componentType = (String)getComponentTypeMeth.invoke(tagObj, new Object[0]);
                        Method getRendererTypeMeth = tagClass.getMethod("getRendererType", new Class[0]);
                        String rendererType = (String)getRendererTypeMeth.invoke(tagObj, new Object[0]);
                        StringBuffer sb = new StringBuffer(256);
                        sb.append("\t<tag>\n\t\t<description><![CDATA[");
                        sb.append(elem.getDescription());
                        sb.append("]]></description>\n");
                        sb.append("\t\t<tag-name>");
                        sb.append(tagName);
                        sb.append("</tag-name>\n\t\t<component>\n\t\t\t<component-type>");
                        sb.append(componentType);
                        sb.append("</component-type>\n");
                        if (rendererType != null) {
                            sb.append("\t\t\t<renderer-type>");
                            sb.append(rendererType);
                            sb.append("</renderer-type>\n");
                        }
                        sb.append("\t\t\t<handler-class>com.icesoft.faces.component.facelets.IceComponentHandler</handler-class>\n");
                        sb.append("\t\t</component>\n");
                        ArrayList<AttributeElement> list = elem.getAttributes();
                        for (AttributeElement attributeElement : list) {
                            sb.append("\t\t<attribute>\n");
                            sb.append("\t\t\t<description><![CDATA[");
                            sb.append(attributeElement.getDescription());
                            sb.append("]]></description>\n");
                            sb.append("\t\t\t<name>");
                            sb.append(attributeElement.getName());
                            sb.append("</name>\n");
                            sb.append("\t\t\t<required>");
                            sb.append(attributeElement.getRequired());
                            sb.append("</required>\n");
                            sb.append("\t\t</attribute>\n");
                        }
                        sb.append("\t</tag>\n");
                        this.faceletsTaglibXmlWriter.write(sb.toString());
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Problem writing tag to eclipse taglib.xml. Tag name: " + elem.getTagName() + ", Tag class: " + elem.getTagClass()), (Throwable)e);
            }
        }
    }
}

