/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Util;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UCharacterCategory;

public class UnicodeUtil {
    public static boolean IsAsciiChar(char inChar) {
        return inChar <= '\u007f';
    }

    public static boolean IsAsciiStr(String inStr) {
        if (inStr == null) {
            return false;
        }
        for (int i = 0; i < inStr.length(); ++i) {
            if (UnicodeUtil.IsAsciiChar(inStr.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int CharToNum(char inChar) {
        return new Character(inChar).hashCode();
    }

    public static String CharToStr(char inChar) {
        return String.valueOf(inChar);
    }

    public static char NumToChar(int inNum) {
        return (char)inNum;
    }

    public static String NumToStr(int inNum) {
        return UnicodeUtil.CharToStr(UnicodeUtil.NumToChar(inNum));
    }

    public static String GetUnicodeName(int inNum) {
        return UCharacter.getName(inNum);
    }

    public static String GetUnicodeName(char inChar) {
        return UCharacter.getName(UnicodeUtil.CharToNum(inChar));
    }

    public static String GetUnicodeBlock(int inNum) {
        return UCharacter.UnicodeBlock.of(inNum).toString();
    }

    public static String GetUnicodeBlock(char inChar) {
        return UCharacter.UnicodeBlock.of(UnicodeUtil.CharToNum(inChar)).toString();
    }

    public static String GetUnicodeCategory(int inNum) {
        return UCharacterCategory.toString(UCharacter.getType(inNum));
    }

    public static String GetUnicodeCategory(char inChar) {
        return UCharacterCategory.toString(UCharacter.getType(UnicodeUtil.CharToNum(inChar)));
    }

    public static String NumToHtmlHex(int inNum) {
        String heading = new String();
        if (inNum == 32) {
            return "&nbsp;";
        }
        heading = inNum < 16 ? "&#X000" : (inNum < 256 ? "&#X00" : (inNum < 4096 ? "&#X0" : "&#X"));
        StringBuffer htmlNum = new StringBuffer();
        htmlNum.append(heading);
        htmlNum.append(Integer.toHexString(inNum));
        htmlNum.append(";");
        return htmlNum.toString();
    }

    public static String NumToUnicodeHex(int inNum) {
        String heading = new String();
        heading = inNum < 16 ? "U+000" : (inNum < 256 ? "U+00" : (inNum < 4096 ? "U+0" : "U+"));
        StringBuffer unicodeHex = new StringBuffer();
        unicodeHex.append(heading);
        unicodeHex.append(Integer.toHexString(inNum).toUpperCase());
        return unicodeHex.toString();
    }

    public static int UnicodeHexToNum(String inUnicodeHex) {
        String valueStr = inUnicodeHex.substring(2);
        return Integer.valueOf(valueStr, 16);
    }

    public static String UnicodeHexToStr(String inUnicodeHex) {
        String outStr = new String();
        if (inUnicodeHex.startsWith("U+")) {
            int inNum = UnicodeUtil.UnicodeHexToNum(inUnicodeHex);
            outStr = UnicodeUtil.NumToStr(inNum);
        }
        return outStr;
    }

    public static String GetUnicodeInfoXNB(int inNum) {
        StringBuffer buf = new StringBuffer();
        buf.append(UnicodeUtil.NumToUnicodeHex(inNum));
        buf.append(", ");
        buf.append(UnicodeUtil.GetUnicodeName(inNum));
        buf.append(", ");
        buf.append(UnicodeUtil.GetUnicodeBlock(inNum));
        return buf.toString();
    }

    public static String GetUnicodeInfoXNB(char inChar) {
        return UnicodeUtil.GetUnicodeInfoXNB(UnicodeUtil.CharToNum(inChar));
    }
}

