/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.RTrieNode;
import gov.nih.nlm.nls.lvg.Trie.RWildCard;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Array;
import java.util.Vector;

public class RTrieTree {
    private RTrieNode root_ = new RTrieNode('$', 0);
    private int nodeNum_ = 1;
    private RTrieNode curNode_ = null;
    private RTrieNode foundNode_ = null;
    private String foundRule_ = new String();
    private boolean firstTime_ = true;

    public RTrieTree() {
    }

    public RTrieTree(String fName) {
        this.LoadRTrieTreeFromFile(fName);
    }

    public void LoadRTrieTreeFromFile(String fName) {
        if (fName == null) {
            return;
        }
        try {
            String line = null;
            BufferedReader in = new BufferedReader(new FileReader(fName));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                this.AddNode(line);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("**Error: problem of opening/reading file '" + fName + "'.");
            System.err.println("Exception: " + e.toString());
        }
    }

    public boolean FindPattern(String term) {
        String curStr = term + '$';
        char[] inCharArray = curStr.toCharArray();
        return this.FindNode(this.root_, inCharArray);
    }

    public void PrintRTrieTree(RTrieNode node) {
        int i;
        if (this.firstTime_) {
            this.firstTime_ = false;
            System.out.println("======== RTrie Tree Information =========");
            System.out.println("Number of nodes: " + this.nodeNum_);
            System.out.println("----------------------------------------");
        }
        System.out.print("--");
        for (i = 0; i < node.GetLevel(); ++i) {
            System.out.print("---");
        }
        System.out.print("level: " + node.GetLevel());
        System.out.println(", key: " + node.GetKey());
        if (node.GetChild() != null) {
            for (i = 0; i < node.GetChild().size(); ++i) {
                RTrieNode childNode = node.GetChild().elementAt(i);
                this.PrintRTrieTree(childNode);
            }
        }
    }

    public String GetFoundRule() {
        return this.foundRule_ + '$';
    }

    private boolean FindNode(RTrieNode node, char[] charArray) {
        char curKey = node.GetKey();
        int curLevel = node.GetLevel();
        int arraySize = Array.getLength(charArray);
        int index = arraySize - 1 - curLevel;
        if (RWildCard.IsMatchKey(curKey, index, charArray)) {
            if (curKey == '^') {
                return true;
            }
            if (node.GetChild() != null) {
                for (int i = 0; i < node.GetChild().size(); ++i) {
                    RTrieNode childNode = node.GetChild().elementAt(i);
                    if (!this.FindNode(childNode, charArray)) continue;
                    this.foundRule_ = this.foundRule_ + childNode.GetKey() + "-";
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private void AddNode(String line) {
        char curChar = ' ';
        this.curNode_ = this.root_;
        for (int i = line.length() - 1 - 1; i >= 0; --i) {
            curChar = line.charAt(i);
            int level = line.length() - 1 - i;
            char parentKey = this.curNode_.GetKey();
            if (this.curNode_ == null) continue;
            if (this.curNode_.GetChild() == null) {
                this.curNode_.SetChild(new Vector<RTrieNode>());
            }
            boolean found = false;
            Vector<RTrieNode> childList = this.curNode_.GetChild();
            char key = curChar;
            for (int j = 0; j < childList.size(); ++j) {
                RTrieNode curChild = childList.elementAt(j);
                if (key != curChild.GetKey()) continue;
                this.curNode_ = curChild;
                found = true;
                break;
            }
            if (found) continue;
            RTrieNode newNode = new RTrieNode(key, level);
            this.InsertNode(this.curNode_.GetChild(), newNode);
            this.curNode_ = newNode;
            ++this.nodeNum_;
        }
    }

    private void InsertNode(Vector<RTrieNode> child, RTrieNode node) {
        int index = this.FindIndex(child, node);
        child.insertElementAt(node, index);
    }

    private int FindIndex(Vector<RTrieNode> child, RTrieNode node) {
        int size;
        int index = size = child.size();
        char key = node.GetKey();
        for (int i = 0; i < size; ++i) {
            RTrieNode curNode = child.elementAt(i);
            if (curNode.GetKey() < key) continue;
            index = i;
            break;
        }
        return index;
    }

    private RTrieNode GetRoot() {
        return this.root_;
    }

    public static void main(String[] args) {
        RTrieTree rules = new RTrieTree();
        rules.LoadRTrieTreeFromFile("../data/rules/removeS.data");
        System.out.println("----- result ---------");
        rules.PrintRTrieTree(rules.GetRoot());
    }
}

