/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentList;
import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTree;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieNode;
import gov.nih.nlm.nls.lvg.Trie.TrieTree;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PersistentTrieTree {
    private String triePath_ = null;
    private String rulePath_ = null;
    private String exceptionPath_ = null;
    private PersistentTree persistentTrie_ = null;

    public PersistentTrieTree(String triePath, String rulePath, String exceptionPath) {
        this.triePath_ = triePath;
        this.rulePath_ = rulePath;
        this.exceptionPath_ = exceptionPath;
        this.persistentTrie_ = new PersistentTree(this.triePath_);
    }

    public void BuildPersistentTrieTree(String inFile) throws IOException {
        TrieTree trieTree = new TrieTree(true);
        trieTree.LoadRulesFromFile(inFile, false, true);
        trieTree.LoadRulesFromFile(inFile, true, false);
        TrieNode curNode = trieTree.GetRoot();
        long parentAddress = -1L;
        this.Insert(curNode, parentAddress);
    }

    public void BuildPersistentTrieTree(boolean isInflection) throws IOException {
        TrieTree trieTree = new TrieTree(true);
        if (isInflection) {
            trieTree.LoadRulesFromFile("../data/rules/", "im.rul", false, true);
            trieTree.LoadRulesFromFile("../data/rules/", "im.rul", true, false);
        } else {
            trieTree.LoadRulesFromFile("../data/rules/", "dm.rul", false, true);
            trieTree.LoadRulesFromFile("../data/rules/", "dm.rul", true, false);
        }
        TrieNode curNode = trieTree.GetRoot();
        long parentAddress = -1L;
        this.Insert(curNode, parentAddress);
    }

    public void PrintPersistentTrieTree() throws IOException {
        int nodeNum = 0;
        nodeNum = PersistentTrieNode.PrintNode(this.persistentTrie_.GetRaf(), this.persistentTrie_.GetRootAddress(), this.rulePath_, this.exceptionPath_);
        System.out.println("------------------------------------");
        System.out.println("-- Number of Node: " + nodeNum);
    }

    public void Close() throws IOException {
        this.persistentTrie_.Close();
    }

    public static void main(String[] args) {
        PersistentTrieTree ptt = new PersistentTrieTree("trie.data", "rule.data", "exception.data");
        boolean isInflection = false;
        if (args.length != 1) {
            System.out.println("Usage: java PersistentTrieTree <-i/d>");
            System.out.println("   -i: build persistent file for inflection");
        } else if (args[0].equals("-i")) {
            isInflection = true;
        }
        try {
            ptt.BuildPersistentTrieTree(isInflection);
            ptt.PrintPersistentTrieTree();
            ptt.Close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void Insert(TrieNode curNode, long parentAddress) throws IOException {
        long ruleAddress = -1L;
        Vector<InflectionRule> rules = curNode.GetRules();
        if (rules != null) {
            PersistentList persistentRule = new PersistentList(this.rulePath_);
            for (int i = 0; i < rules.size(); ++i) {
                InflectionRule rule = rules.elementAt(i);
                Hashtable<String, String> exceptions = rule.GetExceptions();
                long exceptionAddress = -1L;
                boolean newExceptionList = true;
                if (exceptions != null) {
                    PersistentList persistentException = new PersistentList(this.exceptionPath_);
                    Enumeration<String> keyEn = exceptions.keys();
                    Enumeration<String> valueEn = exceptions.elements();
                    while (keyEn.hasMoreElements()) {
                        String key = keyEn.nextElement();
                        String value = valueEn.nextElement();
                        PersistentExceptionNode exceptionNode = new PersistentExceptionNode(key, value);
                        persistentException.Add(exceptionNode);
                        if (!newExceptionList) continue;
                        newExceptionList = false;
                        exceptionAddress = exceptionNode.GetAddress() - 12L;
                    }
                    persistentException.Close();
                }
                PersistentRuleNode ruleNode = new PersistentRuleNode(rule.GetRuleStr(), exceptionAddress);
                persistentRule.Add(ruleNode);
                if (i != 0) continue;
                ruleAddress = ruleNode.GetAddress() - 12L;
            }
            persistentRule.Close();
        }
        char key = curNode.GetKey();
        PersistentTrieNode pNode = new PersistentTrieNode(key, ruleAddress);
        this.persistentTrie_.Add(pNode, parentAddress);
        if (curNode.GetChild() != null) {
            parentAddress = pNode.GetAddress();
            for (int i = 0; i < curNode.GetChild().size(); ++i) {
                TrieNode childNode = curNode.GetChild().elementAt(i);
                this.Insert(childNode, parentAddress);
            }
        }
    }
}

