/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgDef;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgGlobal;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.DerivationCatDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.InflectionCatInflDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.WordSizeDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.FlowListPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.OkCancelResetButtonPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.GridBag;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ModifyFlowDialog
extends JDialog {
    private static String[] item_ = new String[LvgDef.FLOW_NUM];
    private static JList<String> availableList_ = null;
    private static DefaultListModel<String> selectedModel_ = new DefaultListModel();
    private static JList<String> selectedList_ = new JList<String>(selectedModel_);
    private static JFrame owner_ = null;
    private static int flowIndex_ = 0;
    private static ModifyFlowDialog modifyFlowD_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;
    private static final long serialVersionUID = 5L;

    private ModifyFlowDialog(JFrame owner) {
        super(owner, "Eidt a flow", true);
        owner_ = owner;
        this.setLocationRelativeTo(owner);
        this.setSize(500, 400);
        FlowListPanel flowPanel = new FlowListPanel();
        availableList_ = flowPanel.GetList();
        Box button = Box.createVerticalBox();
        JButton addB = new JButton(" Add  ");
        JButton insertB = new JButton("Insert");
        JButton deleteB = new JButton("Delete");
        JButton helpB = new JButton(" Help ");
        button.add(Box.createVerticalStrut(10));
        button.add(addB);
        button.add(Box.createVerticalStrut(10));
        button.add(insertB);
        button.add(Box.createVerticalStrut(10));
        button.add(deleteB);
        button.add(Box.createVerticalStrut(10));
        button.add(helpB);
        selectedList_.setSelectionMode(0);
        JScrollPane selectedSp = new JScrollPane(selectedList_);
        Box selected = Box.createVerticalBox();
        selected.add(new JLabel("Current flow:"));
        selected.add(Box.createVerticalStrut(5));
        selected.add(selectedSp);
        JPanel centerP = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        centerP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.insets = new Insets(10, 5, 20, 5);
        GridBag.SetPosSize(gbc, 0, 0, 1, 3);
        centerP.add((Component)flowPanel, gbc);
        gbc.fill = 0;
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 1, 0, 1, 3);
        centerP.add((Component)button, gbc);
        gbc.fill = 1;
        GridBag.SetPosSize(gbc, 2, 0, 1, 3);
        centerP.add((Component)selected, gbc);
        OkCancelResetButtonPanel buttonP = new OkCancelResetButtonPanel();
        JButton okB = buttonP.GetOkButton();
        JButton cancelB = buttonP.GetCancelButton();
        JButton resetB = buttonP.GetResetButton();
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = availableList_.getSelectedIndex();
                if (index == 60) {
                    WordSizeDialog.AddWordSizeDialog(ModifyFlowDialog.this.getContentPane(), selectedModel_);
                } else if (index == 13) {
                    DerivationCatDialog.AddDerivationCatDialog(owner_, selectedModel_);
                } else if (index == 24) {
                    InflectionCatInflDialog.AddInflectionCatInflDialog(owner_, selectedModel_);
                } else {
                    selectedModel_.addElement(LvgDef.FLOW_FLAG[index]);
                }
            }
        });
        insertB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int srcIndex = availableList_.getSelectedIndex();
                int tarIndex = selectedList_.getSelectedIndex();
                int n = tarIndex = tarIndex > 0 ? tarIndex : 0;
                if (srcIndex == 60) {
                    WordSizeDialog.InsertWordSizeDialog(ModifyFlowDialog.this.getContentPane(), selectedModel_, tarIndex);
                } else if (srcIndex == 13) {
                    DerivationCatDialog.InsertDerivationCatDialog(owner_, selectedModel_, tarIndex);
                } else if (srcIndex == 24) {
                    InflectionCatInflDialog.InsertInflectionCatInflDialog(owner_, selectedModel_, tarIndex);
                } else {
                    selectedModel_.insertElementAt(LvgDef.FLOW_FLAG[srcIndex], tarIndex);
                }
            }
        });
        deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = selectedList_.getSelectedIndex();
                if (index >= 0) {
                    selectedModel_.removeElementAt(index);
                }
            }
        });
        helpB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = availableList_.getSelectedIndex();
                String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
                String flowUrl = "file:" + lvgDir + "docs/designDoc/UDF/flow/" + LvgDef.FLOW_DOC[index];
                if (helpDoc_ == null) {
                    String title = "Lvg Flow Components Documents";
                    String homeUrl = "file:" + lvgDir + "docs/designDoc/UDF/flow/index.html";
                    helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, flowUrl);
                } else {
                    helpDoc_.SetPage(flowUrl);
                }
                helpDoc_.setVisible(true);
            }
        });
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String cmd = "-f";
                for (int i = 0; i < selectedModel_.size(); ++i) {
                    cmd = cmd + ":" + (String)selectedModel_.elementAt(i);
                }
                LvgGlobal.cmd_.SetFlowComponent(cmd, flowIndex_);
                ModifyFlowDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyFlowDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                selectedModel_.removeAllElements();
            }
        });
    }

    public static void ShowDialog(JFrame owner, int flowIndex) {
        if (modifyFlowD_ == null) {
            modifyFlowD_ = new ModifyFlowDialog(owner);
        }
        flowIndex_ = flowIndex;
        ModifyFlowDialog.UpdateSelectedList(flowIndex_);
        modifyFlowD_.setVisible(true);
    }

    private static void UpdateSelectedList(int index) {
        String flowStr = LvgGlobal.cmd_.GetFlowComponent(index);
        String netFlowStr = flowStr.substring(3);
        StringTokenizer buf = new StringTokenizer(netFlowStr, ":");
        selectedModel_.removeAllElements();
        while (buf.hasMoreTokens()) {
            selectedModel_.addElement(buf.nextToken());
        }
    }
}

