/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgDef;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Global.LvgGlobal;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.CategoryDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.InflectionDialog;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.Gui.InputPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiComp.OkCancelResetButtonPanel;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.GridBag;
import gov.nih.nlm.nls.lvg.Tools.GuiTool.GuiLib.LvgHtmlBrowser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InputOptionDialog
extends JDialog {
    private static final int SIZE = LvgDef.INPUT_OPT_NUM;
    private static final int OFFSET = 2;
    private static JCheckBox[] cb_ = new JCheckBox[SIZE];
    private static JTextField[] valueT_ = new JTextField[SIZE];
    private static JButton[] setB_ = new JButton[SIZE];
    private static JButton[] helpB_ = new JButton[SIZE];
    private static int[] size_ = new int[SIZE];
    private static boolean[] valueTFlag_ = new boolean[]{true, true, true, true, true};
    private static boolean[] setBFlag_ = new boolean[]{true, true, false, false, false};
    private static String[] defaults_ = new String[SIZE];
    private static String[] cancelText_ = new String[SIZE];
    private static boolean[] cancelCb_ = new boolean[SIZE];
    private static final int INPUT_NUM = 2;
    private static final int SCREEN_INPUT = 0;
    private static final int FILE_INPUT = 1;
    private static JRadioButton[] rb_ = new JRadioButton[2];
    private static ButtonGroup rbGroup_ = null;
    private static ButtonGroup catGroup_ = null;
    private static ButtonGroup inflGroup_ = null;
    private static JFrame owner_ = null;
    private static InputOptionDialog dialog_ = null;
    private static LvgHtmlBrowser helpDoc_ = null;
    private static final long serialVersionUID = 5L;

    private InputOptionDialog(JFrame owner) {
        super(owner);
        this.setTitle("Lvg Input Options");
        this.setModal(true);
        owner_ = owner;
        this.setLocationRelativeTo(owner);
        this.setSize(420, 480);
        JPanel topP = new JPanel();
        topP.add(new JLabel("Please select input options:"));
        JPanel catInflP = new JPanel();
        catInflP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Categories and Inflections"));
        GridBagLayout gbl = new GridBagLayout();
        catInflP.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(3, 3, 3, 3);
        GridBag.SetWeight(gbc, 100, 100);
        for (int i = 0; i < 2; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            catInflP.add((Component)cb_[i], gbc);
            GridBag.SetPosSize(gbc, 1, i, 1, 1);
            catInflP.add((Component)valueT_[i], gbc);
            if (!setBFlag_[i]) continue;
            GridBag.SetPosSize(gbc, 2, i, 1, 1);
            catInflP.add((Component)setB_[i], gbc);
        }
        GridBag.SetWeight(gbc, 100, 100);
        JPanel filterP = new JPanel();
        filterP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Filter Options"));
        filterP.setLayout(gbl);
        for (int i = 2; i < SIZE - 1; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            filterP.add((Component)cb_[i], gbc);
            GridBag.SetPosSize(gbc, 1, i, 1, 1);
            filterP.add((Component)valueT_[i], gbc);
            GridBag.SetPosSize(gbc, 2, i, 1, 1);
            filterP.add((Component)helpB_[i], gbc);
        }
        valueT_[5].setText(LvgGlobal.inFile_.getPath());
        GridBag.SetWeight(gbc, 100, 100);
        JPanel sourceP = new JPanel();
        sourceP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Input Source Options"));
        sourceP.setLayout(gbl);
        for (int i = 0; i < 2; ++i) {
            GridBag.SetPosSize(gbc, i, 0, 1, 1);
            sourceP.add((Component)rb_[i], gbc);
        }
        GridBag.SetPosSize(gbc, 2, 0, 1, 1);
        sourceP.add((Component)setB_[5], gbc);
        GridBag.SetPosSize(gbc, 3, 0, 1, 1);
        sourceP.add((Component)helpB_[5], gbc);
        GridBag.SetPosSize(gbc, 1, 1, 3, 1);
        sourceP.add((Component)valueT_[5], gbc);
        JPanel centerP = new JPanel();
        centerP.setLayout(new GridBagLayout());
        gbc.insets = new Insets(6, 12, 6, 12);
        GridBag.SetPosSize(gbc, 1, 1, 1, 1);
        centerP.add((Component)catInflP, gbc);
        GridBag.SetPosSize(gbc, 1, 2, 1, 1);
        centerP.add((Component)filterP, gbc);
        GridBag.SetPosSize(gbc, 1, 3, 1, 1);
        centerP.add((Component)sourceP, gbc);
        OkCancelResetButtonPanel bottomP = new OkCancelResetButtonPanel();
        JButton okB = bottomP.GetOkButton();
        JButton cancelB = bottomP.GetCancelButton();
        JButton resetB = bottomP.GetResetButton();
        this.getContentPane().add((Component)topP, "North");
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)bottomP, "South");
        rb_[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                valueT_[5].setEditable(false);
            }
        });
        rb_[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                valueT_[5].setEditable(true);
            }
        });
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LvgGlobal.cmd_.ResetInputOptions();
                for (int i = 2; i < SIZE; ++i) {
                    if (!cb_[i].isSelected()) continue;
                    LvgGlobal.cmd_.AddInputOption("-" + LvgDef.INPUT_PURE_OPT_FLAG[i] + ":" + valueT_[i].getText());
                }
                LvgGlobal.UpdateCmdStr();
                InputPanel.SetShowFile(LvgGlobal.inputFromScreen_);
                LvgGlobal.inFile_ = new File(valueT_[5].getText());
                InputPanel.SetFile(LvgGlobal.inFile_.getPath());
                LvgGlobal.inputFromScreen_ = rb_[0].isSelected();
                InputOptionDialog.this.setVisible(false);
                SwingUtilities.updateComponentTreeUI(owner_);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.RetrieveStatus();
                InputOptionDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.ResetCheckBox();
                for (int i = 0; i < SIZE; ++i) {
                    valueT_[i].setText(defaults_[i]);
                }
                InputOptionDialog.SetSourceToScreen();
            }
        });
        setB_[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryDialog.ShowDialog(owner_, valueT_[0], valueT_[1]);
            }
        });
        setB_[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InflectionDialog.ShowDialog(owner_, valueT_[1], valueT_[0]);
            }
        });
        setB_[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFileChooser dialog = new JFileChooser();
                dialog.setSelectedFile(new File(valueT_[5].getText()));
                dialog.setDialogTitle("Choose the input file");
                dialog.setMultiSelectionEnabled(false);
                if (dialog.showDialog(owner_, "Select") == 0) {
                    valueT_[5].setText(dialog.getSelectedFile().getPath());
                }
            }
        });
        helpB_[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.this.ShowHelp(2);
            }
        });
        helpB_[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.this.ShowHelp(3);
            }
        });
        helpB_[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.this.ShowHelp(4);
            }
        });
        helpB_[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.this.ShowHelp(5);
            }
        });
    }

    public static void ShowDialog(JFrame owner) {
        if (dialog_ == null) {
            dialog_ = new InputOptionDialog(owner);
        }
        InputOptionDialog.StoreStatus();
        dialog_.setVisible(true);
    }

    public static int GetTermFieldNum() {
        int termFieldNum = 1;
        if (cb_[2].isSelected()) {
            termFieldNum = Integer.parseInt(valueT_[2].getText());
        }
        return termFieldNum;
    }

    public static long GetCategory() {
        long cat = Long.parseLong(valueT_[0].getText());
        return cat;
    }

    public static void SetCategory(long cat) {
        valueT_[0].setText(Long.toString(cat));
    }

    public static long GetInflection() {
        long infl = Long.parseLong(valueT_[1].getText());
        return infl;
    }

    public static void SetInflection(long infl) {
        valueT_[1].setText(Long.toString(infl));
    }

    public static void ResetCheckBox() {
        for (int i = 0; i < SIZE; ++i) {
            if (i < 2) {
                cb_[i].setSelected(true);
                continue;
            }
            cb_[i].setSelected(false);
        }
    }

    public static void SetSourceToScreen() {
        rb_[0].setSelected(true);
        LvgGlobal.inputFromScreen_ = true;
        valueT_[5].setEditable(false);
    }

    public static int GetCategoryFieldNum() {
        int categoryFieldNum = -1;
        if (cb_[3].isSelected()) {
            categoryFieldNum = Integer.parseInt(valueT_[3].getText());
        }
        return categoryFieldNum;
    }

    public static int GetInflectionFieldNum() {
        int inflectionFieldNum = -1;
        if (cb_[3].isSelected()) {
            inflectionFieldNum = Integer.parseInt(valueT_[4].getText());
        }
        return inflectionFieldNum;
    }

    private static void StoreStatus() {
        for (int i = 0; i < SIZE; ++i) {
            InputOptionDialog.cancelCb_[i] = cb_[i].isSelected();
            InputOptionDialog.cancelText_[i] = valueT_[i].getText();
        }
    }

    private static void RetrieveStatus() {
        for (int i = 0; i < SIZE; ++i) {
            cb_[i].setSelected(cancelCb_[i]);
            valueT_[i].setText(cancelText_[i]);
        }
        rb_[0].setSelected(LvgGlobal.inputFromScreen_);
        rb_[1].setSelected(!LvgGlobal.inputFromScreen_);
    }

    private void ShowHelp(int index) {
        String lvgDir = LvgGlobal.config_.GetConfiguration("LVG_DIR");
        String optionUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgOptions/" + LvgDef.INPUT_OPT_DOC[index];
        if (helpDoc_ == null) {
            String title = "Input Filter Option Documents";
            String homeUrl = "file:" + lvgDir + "docs/designDoc/LifeCycle/requirement/lvgInputFilter.html";
            helpDoc_ = new LvgHtmlBrowser(owner_, title, 600, 800, homeUrl, optionUrl);
        } else {
            helpDoc_.SetPage(optionUrl);
        }
        helpDoc_.setVisible(true);
    }

    static {
        InputOptionDialog.defaults_[0] = Long.toString(2047L);
        InputOptionDialog.defaults_[1] = Long.toString(0xFFFFFFL);
        InputOptionDialog.defaults_[2] = "1";
        InputOptionDialog.defaults_[3] = "0";
        InputOptionDialog.defaults_[4] = "0";
        InputOptionDialog.defaults_[5] = LvgGlobal.inFile_.getPath();
        InputOptionDialog.size_[0] = 4;
        InputOptionDialog.size_[1] = 8;
        InputOptionDialog.size_[3] = 3;
        InputOptionDialog.size_[4] = 3;
        InputOptionDialog.size_[2] = 3;
        for (int i = 0; i < SIZE; ++i) {
            if (i < 2) {
                InputOptionDialog.cb_[i] = new JCheckBox(LvgDef.INPUT_OPT[i]);
                cb_[i].setSelected(true);
            } else {
                InputOptionDialog.cb_[i] = new JCheckBox(LvgDef.INPUT_OPT[i] + " (-" + LvgDef.INPUT_OPT_FLAG[i] + ")");
            }
            InputOptionDialog.setB_[i] = new JButton("Setting");
            setB_[i].setPreferredSize(new Dimension(100, 21));
            InputOptionDialog.helpB_[i] = new JButton("Help");
            helpB_[i].setPreferredSize(new Dimension(50, 21));
            InputOptionDialog.valueT_[i] = new JTextField(defaults_[i], size_[i]);
        }
        valueT_[5].setEditable(false);
        InputOptionDialog.rb_[0] = new JRadioButton("Screen");
        InputOptionDialog.rb_[1] = new JRadioButton("File");
        rb_[0].setSelected(true);
        rbGroup_ = new ButtonGroup();
        rbGroup_.add(rb_[0]);
        rbGroup_.add(rb_[1]);
        catGroup_ = new ButtonGroup();
        catGroup_.add(cb_[0]);
        catGroup_.add(cb_[3]);
        inflGroup_ = new ButtonGroup();
        inflGroup_.add(cb_[1]);
        inflGroup_.add(cb_[4]);
    }
}

