/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.util.Comparator;

public class LexItemComparator<T>
implements Comparator<T> {
    public static final int NONE = 0;
    public static final int TERM = 1;
    public static final int TERM_CAT = 2;
    public static final int TERM_CAT_INFL = 3;
    public static final int LVG_RULE = 10;
    public static final int ALPHABETIC = 11;
    private int rule_ = 0;
    private boolean caseFlag_ = true;
    private LvgComparator<String> lc_ = new LvgComparator();
    private static final int[] CAT_PRIORITY = new int[11];

    @Override
    public int compare(T o1, T o2) {
        int out = 0;
        switch (this.rule_) {
            case 1: 
            case 11: {
                out = this.CompareByAlphaBetic(o1, o2);
                break;
            }
            case 2: {
                out = this.CompareByTermCat(o1, o2);
                break;
            }
            case 3: {
                out = this.CompareByTermCatInfl(o1, o2);
                break;
            }
            case 10: {
                out = this.CompareByLvg(o1, o2);
                break;
            }
            default: {
                out = this.CompareForCombine(o1, o2);
            }
        }
        return out;
    }

    public void SetRule(int rule) {
        this.rule_ = rule;
    }

    public void SetCase(boolean caseFlag) {
        this.caseFlag_ = caseFlag;
    }

    public static int GetCategoryPriority(long category) {
        int priority = 12;
        int catBit = Category.GetBitIndex(category);
        if (catBit > 0) {
            priority = CAT_PRIORITY[catBit];
        }
        return priority;
    }

    private int CompareByAlphaBetic(T o1, T o2) {
        LexItem item1 = (LexItem)o1;
        LexItem item2 = (LexItem)o2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int out = this.lc_.compare(item1.GetTargetTerm(), item2.GetTargetTerm());
        return out;
    }

    private int CompareByTermCat(T o1, T o2) {
        LexItem item1 = (LexItem)o1;
        LexItem item2 = (LexItem)o2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int out = this.lc_.compare(item1.GetTargetTerm(), item2.GetTargetTerm());
        if (out == 0) {
            out = (int)(item1.GetTargetCategory().GetValue() - item2.GetTargetCategory().GetValue());
        }
        return out;
    }

    private int CompareByTermCatInfl(T o1, T o2) {
        LexItem item1 = (LexItem)o1;
        LexItem item2 = (LexItem)o2;
        this.lc_.SetLengthFlag(false);
        this.lc_.SetCase(this.caseFlag_);
        int out = this.lc_.compare(item1.GetTargetTerm(), item2.GetTargetTerm());
        if (out == 0 && (out = (int)(item1.GetTargetCategory().GetValue() - item2.GetTargetCategory().GetValue())) == 0) {
            long temp = item1.GetTargetInflection().GetValue() - item2.GetTargetInflection().GetValue();
            out = temp > 0L ? 1 : (temp < 0L ? -1 : 0);
        }
        return out;
    }

    private int CompareByLvg(T o1, T o2) {
        int c2;
        LexItem item1 = (LexItem)o1;
        LexItem item2 = (LexItem)o2;
        int c1 = LexItemComparator.GetCategoryPriority(item1.GetTargetCategory().GetValue());
        if (c1 != (c2 = LexItemComparator.GetCategoryPriority(item2.GetTargetCategory().GetValue()))) {
            return c1 - c2;
        }
        this.lc_.SetLengthFlag(true);
        this.lc_.SetCase(false);
        int out = this.lc_.compare(item1.GetTargetTerm(), item2.GetTargetTerm());
        return out;
    }

    private int CompareForCombine(T o1, T o2) {
        LexItem item1 = (LexItem)o1;
        LexItem item2 = (LexItem)o2;
        int out = -1;
        if (this.rule_ == 0) {
            return out;
        }
        this.lc_.SetLengthFlag(true);
        this.lc_.SetCase(this.caseFlag_);
        out = this.lc_.compare(item1.GetTargetTerm(), item2.GetTargetTerm());
        if (out == 0) {
            switch (this.rule_) {
                case 4: {
                    out = this.lc_.compare(item1.GetMutateInformation(), item2.GetMutateInformation());
                    break;
                }
                case 2: {
                    int c1 = LexItemComparator.GetCategoryPriority(item1.GetTargetCategory().GetValue());
                    int c2 = LexItemComparator.GetCategoryPriority(item2.GetTargetCategory().GetValue());
                    out = c1 - c2;
                    break;
                }
                case 3: {
                    out = this.lc_.compare(String.valueOf(item1.GetTargetInflection().GetValue()), String.valueOf(item2.GetTargetInflection().GetValue()));
                }
            }
        }
        return out;
    }

    static {
        LexItemComparator.CAT_PRIORITY[7] = 1;
        LexItemComparator.CAT_PRIORITY[0] = 2;
        LexItemComparator.CAT_PRIORITY[10] = 3;
        LexItemComparator.CAT_PRIORITY[1] = 4;
        LexItemComparator.CAT_PRIORITY[8] = 5;
        LexItemComparator.CAT_PRIORITY[9] = 6;
        LexItemComparator.CAT_PRIORITY[4] = 7;
        LexItemComparator.CAT_PRIORITY[5] = 8;
        LexItemComparator.CAT_PRIORITY[6] = 9;
        LexItemComparator.CAT_PRIORITY[2] = 10;
        LexItemComparator.CAT_PRIORITY[3] = 11;
    }
}

