/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.util.Vector;

public class ToInflectionByCatInfl
extends Transformation
implements Cloneable {
    private static final String INFO = "InflectionByCatInfl";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, long outCategory, long outInflection, boolean detailsFlag, boolean mutateFlag) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(INFO);
        buffer.append(" <");
        buffer.append(outCategory);
        buffer.append(", ");
        buffer.append(outInflection);
        buffer.append(">");
        String infoStr = buffer.toString();
        Vector<LexItem> ori = ToInflection.InflectWords(in, conn, trie, restrictFlag, infoStr, detailsFlag, mutateFlag, 20);
        Vector<LexItem> out = ToInflectionByCatInfl.RestrictOutputByCatInfl(ori, outCategory, outInflection);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToInflectionByCatInfl.GetTestStr(args, "sleep");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToInflectionByCatInfl.Mutate(in, conn, trie, 2, 128L, 1L, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToInflectionByCatInfl.PrintResults(in, outs);
    }

    private static Vector<LexItem> RestrictOutputByCatInfl(Vector<LexItem> in, long category, long inflection) {
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < in.size(); ++i) {
            LexItem temp = in.elementAt(i);
            if (!OutputFilter.IsRecContainCategoryInflection(temp, category, inflection)) continue;
            out.addElement(temp);
        }
        return out;
    }
}

